/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.version.VersionUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ConditionalCommand
extends Command {
    private final Condition[] conditions;
    private final Command delegate;

    public ConditionalCommand(Condition[] conditions, Command delegate) {
        this.conditions = conditions;
        this.delegate = delegate;
    }

    @Override
    protected void executeCommand() {
        for (Condition condition : this.conditions) {
            if (condition.isSatisfied()) continue;
            return;
        }
        this.delegate.execute();
    }

    @Override
    protected Command myUndoCommand() {
        return null;
    }

    public Command getDelegate() {
        return this.delegate;
    }

    public Condition[] getConditions() {
        return this.conditions;
    }

    public static abstract class Condition {
        public abstract boolean isSatisfied();
    }

    public static class Gt
    extends Condition {
        private final String property;
        private final String value;

        public Gt(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isSatisfied() {
            String propertyValue = GameModule.getGameModule().getAttributeValueString(this.property);
            return VersionUtils.compareVersions(propertyValue, this.value) > 0;
        }
    }

    public static class Lt
    extends Condition {
        private final String property;
        private final String value;

        public Lt(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isSatisfied() {
            String propertyValue = GameModule.getGameModule().getAttributeValueString(this.property);
            return VersionUtils.compareVersions(propertyValue, this.value) < 0;
        }
    }

    public static class Not
    extends Condition {
        private final Condition sub;

        public Not(Condition sub) {
            this.sub = sub;
        }

        @Override
        public boolean isSatisfied() {
            return !this.sub.isSatisfied();
        }

        public Condition getSubCondition() {
            return this.sub;
        }
    }

    public static class Eq
    extends Condition {
        private final String property;
        private final List<String> allowed;

        public Eq(String property, List<String> allowed) {
            this.property = property;
            this.allowed = allowed;
        }

        @Deprecated
        public Eq(String property, Vector<String> allowed) {
            this.property = property;
            this.allowed = allowed;
        }

        public String getProperty() {
            return this.property;
        }

        public List<String> getValueList() {
            return Collections.unmodifiableList(this.allowed);
        }

        @Deprecated(since="2020-08-06", forRemoval=true)
        public Enumeration<String> getValues() {
            ProblemDialog.showDeprecated("2020-08-06");
            return Collections.enumeration(this.allowed);
        }

        @Override
        public boolean isSatisfied() {
            String propertyValue = GameModule.getGameModule().getAttributeValueString(this.property);
            return this.allowed.contains(propertyValue);
        }
    }
}

