/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.BadDataReport;
import VASSAL.configure.Configurer;
import VASSAL.tools.ColorButton;
import VASSAL.tools.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorConfigurer
extends Configurer {
    private JPanel p;
    private ColorButton cb;

    public ColorConfigurer(String key, String name) {
        this(key, name, Color.black);
    }

    public ColorConfigurer(String key, String name, Color val) {
        super(key, name, val);
    }

    @Override
    public String getValueString() {
        return this.value == null ? "" : ColorConfigurer.colorToString(this.colorValue());
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.cb != null) {
            this.cb.setColor((Color)o);
        }
    }

    @Override
    public void setValue(String s) {
        this.setValue(ColorConfigurer.stringToColor(s));
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.getName()));
            this.cb = new ColorButton(this.colorValue());
            this.cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorConfigurer.this.setValue(JColorChooser.showDialog(null, ColorConfigurer.this.getName(), ColorConfigurer.this.colorValue()));
                }
            });
            this.p.add(this.cb);
        }
        return this.p;
    }

    private Color colorValue() {
        return (Color)this.value;
    }

    public static String colorToString(Color c) {
        return c == null ? null : c.getRed() + "," + c.getGreen() + "," + c.getBlue();
    }

    public static Color stringToColor(String s) {
        if (s == null || s.length() == 0 || "null".equals(s)) {
            return null;
        }
        try {
            if (s.startsWith("0X") || s.startsWith("0x")) {
                return Color.decode(s);
            }
            StringTokenizer st = new StringTokenizer(s, ",");
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport("not an integer", s, e));
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            ErrorDialog.dataWarning(new BadDataReport("bad color", s, e));
        }
        return Color.BLACK;
    }
}

