/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class StringEnumConfigurer
extends Configurer {
    private String[] validValues;
    private JComboBox<String> box;
    private Box panel;

    public StringEnumConfigurer(String key, String name, String[] validValues) {
        super(key, name);
        this.validValues = validValues;
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = Box.createHorizontalBox();
            this.panel.add(new JLabel(this.name));
            this.box = new JComboBox<String>(this.validValues);
            this.box.setMaximumSize(new Dimension(this.box.getMaximumSize().width, this.box.getPreferredSize().height));
            if (this.isValidValue(this.getValue())) {
                this.box.setSelectedItem(this.getValue());
            } else if (this.validValues.length > 0) {
                this.box.setSelectedIndex(0);
            }
            this.box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringEnumConfigurer.this.noUpdate = true;
                    StringEnumConfigurer.this.setValue(StringEnumConfigurer.this.box.getSelectedItem());
                    StringEnumConfigurer.this.noUpdate = false;
                }
            });
            this.panel.add(this.box);
        }
        return this.panel;
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    public void setEditable(boolean enabled) {
        this.box.setEditable(enabled);
    }

    public boolean isValidValue(Object o) {
        for (String validValue : this.validValues) {
            if (!validValue.equals(o)) continue;
            return true;
        }
        return false;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String[] s) {
        this.validValues = s;
        if (this.box == null) {
            this.getControls();
        }
        this.box.setModel(new DefaultComboBoxModel<String>(this.validValues));
    }

    @Override
    public void setValue(Object o) {
        if (this.validValues == null || this.isValidValue(o)) {
            super.setValue(o);
            if (!this.noUpdate && this.box != null) {
                this.box.setSelectedItem(o);
            }
        }
    }

    @Override
    public String getValueString() {
        return this.box != null ? (String)this.box.getSelectedItem() : this.validValues[0];
    }

    @Override
    public void setValue(String s) {
        this.setValue((Object)s);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        StringEnumConfigurer c = new StringEnumConfigurer(null, "Pick one: ", new String[]{"one", "two", "three"});
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getPropertyName() + " = " + evt.getNewValue());
            }
        });
        f.add(c.getControls());
        f.pack();
        f.setVisible(true);
    }
}

