/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;

public class ImagePicker
extends JPanel
implements MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final String NO_IMAGE = "(No Image)";
    private String imageName = null;
    protected static Font FONT = new Font("Dialog", 0, 11);
    private final JTextArea noImage = new JTextArea(1, 10);
    private final JComboBox<String> select;
    private final OpIcon icon;
    private final JLabel imageView;
    private final JPanel imageViewer;
    private final JScrollPane imageScroller;

    public ImagePicker() {
        this.noImage.setFont(FONT);
        this.noImage.setText("Double-click here to add new image");
        this.noImage.addMouseListener(this);
        this.noImage.setEditable(false);
        this.noImage.setLineWrap(true);
        this.noImage.setWrapStyleWord(true);
        this.noImage.setMinimumSize(new Dimension(15, 32));
        this.icon = new OpIcon();
        this.imageView = new JLabel(this.icon);
        this.imageView.addMouseListener(this);
        this.imageViewer = new JPanel(new BorderLayout());
        this.imageScroller = new ScrollPane(this.imageView, 20, 30);
        this.imageViewer.add((Component)this.imageScroller, "Center");
        this.select = new JComboBox<String>((String[])ArrayUtils.addFirst((Object[])GameModule.getGameModule().getDataArchive().getImageNames(), (Object)NO_IMAGE));
        this.select.addItemListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.noImage);
        this.add(this.select);
    }

    public String getImageName() {
        return this.imageName;
    }

    protected void setViewSize() {
    }

    public void setImageName(String name) {
        this.imageName = name;
        this.remove(0);
        if (name == null || name.trim().length() == 0 || name.equals(NO_IMAGE)) {
            this.imageName = "";
            this.add((Component)this.noImage, 0);
        } else {
            this.icon.setOp(Op.load(this.imageName));
            Dimension d = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
            if (d.width > 200) {
                d.width = 200;
            }
            d.height = d.height > 200 ? 200 : (d.height += 4);
            this.imageScroller.setPreferredSize(d);
            this.imageScroller.setMinimumSize(d);
            this.add((Component)this.imageViewer, 0);
        }
        this.select.removeItemListener(this);
        this.select.setSelectedItem(name);
        if (name != null && !name.equals(this.select.getSelectedItem())) {
            this.select.setSelectedItem(name + ".gif");
        }
        this.select.addItemListener(this);
        this.revalidate();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.pack();
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && SwingUtils.isMainMouseButtonDown(e)) {
            this.pickImage();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setImageName((String)this.select.getSelectedItem());
    }

    public void pickImage() {
        GameModule gm = GameModule.getGameModule();
        FileChooser fc = gm.getFileChooser();
        fc.setFileFilter(new ImageFileFilter());
        if (fc.showOpenDialog(this) == 0 && fc.getSelectedFile().exists()) {
            String name = fc.getSelectedFile().getName();
            gm.getArchiveWriter().addImage(fc.getSelectedFile().getPath(), name);
            this.select.setModel(new DefaultComboBoxModel<String>((String[])ArrayUtils.addFirst((Object[])gm.getDataArchive().getImageNames(), (Object)NO_IMAGE)));
            this.setImageName(name);
        } else {
            this.setImageName(NO_IMAGE);
        }
        this.repaint();
    }
}

