/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.CalculatedProperty;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.MenuSeparator;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class PieceDefiner
extends JPanel
implements HelpWindowExtension {
    private static final long serialVersionUID = 1L;
    protected static DefaultListModel<GamePiece> availableModel;
    protected DefaultListModel<GamePiece> inUseModel;
    protected ListCellRenderer r;
    protected PieceSlot slot;
    private GamePiece piece;
    protected static TraitClipboard clipBoard;
    protected String pieceId = "";
    protected JLabel pieceIdLabel = new JLabel("");
    protected GpIdSupport gpidSupport;
    protected boolean changed;
    protected JList<GamePiece> availableList;
    private JButton helpButton;
    private JButton addButton;
    private JButton removeButton;
    private JList<GamePiece> inUseList;
    private JButton propsButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    protected JButton copyButton;
    protected JButton pasteButton;

    public PieceDefiner() {
        PieceDefiner.initDefinitions();
        this.inUseModel = new DefaultListModel();
        this.r = new Renderer();
        this.slot = new PieceSlot();
        this.initComponents();
        this.availableList.setSelectedIndex(0);
        this.setChanged(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    public PieceDefiner(String id, GpIdSupport s) {
        this();
        this.pieceId = id;
        this.pieceIdLabel.setText("Id: " + id);
        this.gpidSupport = s;
    }

    public PieceDefiner(GpIdSupport s) {
        this();
        this.gpidSupport = s;
    }

    protected static void initDefinitions() {
        if (availableModel == null) {
            availableModel = new DefaultListModel();
            availableModel.addElement(new BasicPiece());
            availableModel.addElement(new Delete());
            availableModel.addElement(new Clone());
            availableModel.addElement(new Embellishment());
            availableModel.addElement(new UsePrototype());
            availableModel.addElement(new Labeler());
            availableModel.addElement(new ReportState());
            availableModel.addElement(new TriggerAction());
            availableModel.addElement(new GlobalHotKey());
            availableModel.addElement(new ActionButton());
            availableModel.addElement(new FreeRotator());
            availableModel.addElement(new Pivot());
            availableModel.addElement(new Hideable());
            availableModel.addElement(new Obscurable());
            availableModel.addElement(new SendToLocation());
            availableModel.addElement(new CounterGlobalKeyCommand());
            availableModel.addElement(new Translate());
            availableModel.addElement(new ReturnToDeck());
            availableModel.addElement(new Immobilized());
            availableModel.addElement(new PropertySheet());
            availableModel.addElement(new TableInfo());
            availableModel.addElement(new PlaceMarker());
            availableModel.addElement(new Replace());
            availableModel.addElement(new NonRectangular());
            availableModel.addElement(new PlaySound());
            availableModel.addElement(new MovementMarkable());
            availableModel.addElement(new Footprint());
            availableModel.addElement(new AreaOfEffect());
            availableModel.addElement(new SubMenu());
            availableModel.addElement(new MenuSeparator());
            availableModel.addElement(new RestrictCommands());
            availableModel.addElement(new Restricted());
            availableModel.addElement(new Marker());
            availableModel.addElement(new DynamicProperty());
            availableModel.addElement(new CalculatedProperty());
            availableModel.addElement(new SetGlobalProperty());
        }
    }

    public static void addDefinition(GamePiece definition) {
        PieceDefiner.initDefinitions();
        availableModel.addElement(definition);
    }

    public void setPiece(GamePiece piece) {
        this.inUseModel.clear();
        while (piece instanceof Decorator) {
            Class<?> pieceClass = piece.getClass();
            this.inUseModel.insertElementAt(piece, 0);
            boolean contains = false;
            int j = availableModel.size();
            for (int i = 0; i < j; ++i) {
                if (!pieceClass.isInstance(availableModel.elementAt(i))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                try {
                    availableModel.addElement((GamePiece)pieceClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, pieceClass);
                }
            }
            piece = ((Decorator)piece).piece;
        }
        this.inUseModel.insertElementAt(piece == null ? new BasicPiece() : piece, 0);
        this.inUseList.setSelectedIndex(0);
        this.refresh();
    }

    @Override
    @Deprecated
    public void setBaseWindow(HelpWindow w) {
    }

    private void refresh() {
        this.piece = this.inUseModel.getSize() > 0 ? this.inUseModel.lastElement() : null;
        this.slot.setPiece(this.piece);
        this.slot.getComponent().repaint();
    }

    public GamePiece getPiece() {
        return this.piece;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.slot.getComponent());
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 0));
        JPanel availablePanel = new JPanel();
        JScrollPane availableScroll = new JScrollPane();
        this.availableList = new JList();
        this.helpButton = new JButton();
        JButton importButton = new JButton();
        JPanel addRemovePanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        JPanel inUsePanel = new JPanel();
        JScrollPane inUseScroll = new JScrollPane();
        this.inUseList = new JList();
        this.propsButton = new JButton();
        JPanel moveUpDownPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        availablePanel.setLayout(new BoxLayout(availablePanel, 1));
        this.availableList.setModel(availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.setCellRenderer(this.r);
        this.availableList.addListSelectionListener(evt -> {
            GamePiece o = this.availableList.getSelectedValue();
            this.helpButton.setEnabled(o instanceof EditablePiece && ((EditablePiece)o).getHelpFile() != null);
            this.addButton.setEnabled(o instanceof Decorator);
        });
        availableScroll.setViewportView(this.availableList);
        availableScroll.setBorder(new TitledBorder("Available Traits"));
        availablePanel.add(availableScroll);
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(evt -> this.showHelpForPiece());
        availablePanel.add(this.helpButton);
        importButton.setText("Import");
        importButton.addActionListener(evt -> {
            String className = JOptionPane.showInputDialog(this, (Object)"Enter fully-qualified name of Java class to import");
            this.importPiece(className);
        });
        availablePanel.add(importButton);
        controls.add(availablePanel);
        addRemovePanel.setLayout(new BoxLayout(addRemovePanel, 1));
        this.addButton.setText("Add ->");
        this.addButton.addActionListener(evt -> {
            GamePiece selected = this.availableList.getSelectedValue();
            if (selected instanceof Decorator) {
                if (this.inUseModel.getSize() > 0) {
                    Decorator c = (Decorator)selected;
                    this.addTrait(c);
                    if (this.inUseModel.lastElement().getClass() == c.getClass() && !this.edit(this.inUseModel.size() - 1) && !this.inUseModel.isEmpty()) {
                        this.removeTrait(this.inUseModel.size() - 1);
                    }
                }
            } else if (selected != null && this.inUseModel.getSize() == 0) {
                GamePiece p = null;
                try {
                    p = (GamePiece)selected.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, selected.getClass());
                }
                if (p != null) {
                    this.setPiece(p);
                    if (this.inUseModel.getSize() > 0 && !this.edit(0)) {
                        this.removeTrait(0);
                    }
                }
            }
        });
        this.addButton.setAlignmentX(0.5f);
        addRemovePanel.add(this.addButton);
        this.removeButton.setText("<- Remove");
        this.removeButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index >= 0) {
                this.removeTrait(index);
                if (this.inUseModel.getSize() > 0) {
                    this.inUseList.setSelectedIndex(Math.min(this.inUseModel.getSize() - 1, Math.max(index, 0)));
                }
            }
        });
        this.removeButton.setAlignmentX(0.5f);
        addRemovePanel.add(this.removeButton);
        this.pieceIdLabel.setAlignmentX(0.5f);
        addRemovePanel.add(this.pieceIdLabel);
        controls.add(addRemovePanel);
        inUsePanel.setLayout(new BoxLayout(inUsePanel, 1));
        this.inUseList.setModel(this.inUseModel);
        this.inUseList.setSelectionMode(0);
        this.inUseList.setCellRenderer(this.r);
        this.inUseList.addListSelectionListener(evt -> {
            GamePiece o = this.inUseList.getSelectedValue();
            this.propsButton.setEnabled(o instanceof EditablePiece);
            int index = this.inUseList.getSelectedIndex();
            boolean copyAndRemove = this.inUseModel.size() > 0 && (index > 0 || !(this.inUseModel.getElementAt(0) instanceof BasicPiece));
            this.copyButton.setEnabled(copyAndRemove);
            this.removeButton.setEnabled(copyAndRemove);
            this.pasteButton.setEnabled(clipBoard != null);
            this.moveUpButton.setEnabled(index > 1);
            this.moveDownButton.setEnabled(index > 0 && index < this.inUseModel.size() - 1);
        });
        this.inUseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e) && (index = PieceDefiner.this.inUseList.locationToIndex(e.getPoint())) >= 0) {
                    PieceDefiner.this.edit(index);
                }
            }
        });
        inUseScroll.setViewportView(this.inUseList);
        inUseScroll.setBorder(new TitledBorder("Current Traits"));
        inUsePanel.add(inUseScroll);
        this.propsButton.setText("Properties");
        this.propsButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index >= 0) {
                this.edit(index);
            }
        });
        inUsePanel.add(this.propsButton);
        controls.add(inUsePanel);
        moveUpDownPanel.setLayout(new BoxLayout(moveUpDownPanel, 1));
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index > 1 && index < this.inUseModel.size()) {
                this.moveDecoratorUp(index);
            }
        });
        moveUpDownPanel.add(this.moveUpButton);
        this.moveDownButton.setText("Move Down");
        this.moveDownButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index > 0 && index < this.inUseModel.size() - 1) {
                this.moveDecoratorDown(index);
            }
        });
        moveUpDownPanel.add(this.moveDownButton);
        this.copyButton.setText("Copy");
        this.copyButton.addActionListener(evt -> {
            this.pasteButton.setEnabled(true);
            int index = this.inUseList.getSelectedIndex();
            clipBoard = new TraitClipboard((Decorator)this.inUseModel.get(index));
        });
        moveUpDownPanel.add(this.copyButton);
        this.pasteButton.setText("Paste");
        this.pasteButton.setEnabled(clipBoard != null);
        this.pasteButton.addActionListener(evt -> {
            if (clipBoard != null) {
                this.paste();
            }
        });
        moveUpDownPanel.add(this.pasteButton);
        controls.add(moveUpDownPanel);
        this.add(controls);
    }

    protected void paste() {
        Decorator c = (Decorator)GameModule.getGameModule().createPiece(clipBoard.getType(), null);
        if (c instanceof PlaceMarker) {
            ((PlaceMarker)c).updateGpId(GameModule.getGameModule().getGpIdSupport());
        }
        c.setInner(this.inUseModel.lastElement());
        this.inUseModel.addElement(c);
        c.mySetState(clipBoard.getState());
        this.refresh();
    }

    protected void moveDecoratorDown(int index) {
        GamePiece selm1 = this.inUseModel.elementAt(index - 1);
        Decorator sel = (Decorator)this.inUseModel.elementAt(index);
        Decorator selp1 = (Decorator)this.inUseModel.elementAt(index + 1);
        Decorator selp2 = index < this.inUseModel.size() - 2 ? (Decorator)this.inUseModel.elementAt(index + 2) : null;
        selp1.setInner(selm1);
        sel.setInner(selp1);
        if (selp2 != null) {
            selp2.setInner(sel);
        }
        this.inUseModel.setElementAt(selp1, index);
        this.inUseModel.setElementAt(sel, index + 1);
        this.inUseModel.lastElement().setProperty("Outer", null);
        this.inUseList.setSelectedIndex(index + 1);
        this.refresh();
        this.setChanged(true);
    }

    protected void moveDecoratorUp(int index) {
        GamePiece selm2 = this.inUseModel.elementAt(index - 2);
        Decorator sel = (Decorator)this.inUseModel.elementAt(index);
        Decorator selm1 = (Decorator)this.inUseModel.elementAt(index - 1);
        Decorator selp1 = index < this.inUseModel.size() - 1 ? (Decorator)this.inUseModel.elementAt(index + 1) : null;
        sel.setInner(selm2);
        selm1.setInner(sel);
        if (selp1 != null) {
            selp1.setInner(selm1);
        }
        this.inUseModel.setElementAt(selm1, index);
        this.inUseModel.setElementAt(sel, index - 1);
        this.inUseModel.lastElement().setProperty("Outer", null);
        this.inUseList.setSelectedIndex(index - 1);
        this.refresh();
        this.setChanged(true);
    }

    protected void importPiece(String className) {
        if (className == null) {
            return;
        }
        Object o = null;
        try {
            o = GameModule.getGameModule().getDataArchive().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleImportClassFailure(t, className);
        }
        if (o == null) {
            return;
        }
        if (o instanceof GamePiece) {
            availableModel.addElement(o);
        } else {
            ErrorDialog.show("Error.not_a_gamepiece", className);
        }
    }

    private void showHelpForPiece() {
        GamePiece o = this.availableList.getSelectedValue();
        if (o instanceof EditablePiece) {
            HelpFile h = ((EditablePiece)o).getHelpFile();
            BrowserSupport.openURL(h.getContents().toString());
        }
    }

    protected boolean edit(int index) {
        GamePiece o = this.inUseModel.elementAt(index);
        if (!(o instanceof EditablePiece)) {
            return false;
        }
        EditablePiece p = (EditablePiece)o;
        if (p.getEditor() != null) {
            Window w = SwingUtilities.getWindowAncestor(this);
            Ed ed = w instanceof Frame ? new Ed((Frame)w, p) : (w instanceof Dialog ? new Ed((Dialog)w, p) : new Ed((Frame)null, p));
            String oldState = p.getState();
            String oldType = p.getType();
            ed.setVisible(true);
            PieceEditor c = ed.getEditor();
            if (c != null) {
                p.mySetType(c.getType());
                if (p instanceof Decorator) {
                    ((Decorator)((Object)p)).mySetState(c.getState());
                } else {
                    p.setState(c.getState());
                }
                if (!p.getType().equals(oldType) || !p.getState().equals(oldState)) {
                    this.setChanged(true);
                }
                this.refresh();
                return true;
            }
        }
        return false;
    }

    protected void removeTrait(int index) {
        this.inUseModel.removeElementAt(index);
        if (index < this.inUseModel.size()) {
            ((Decorator)this.inUseModel.elementAt(index)).setInner(this.inUseModel.elementAt(index - 1));
        }
        this.refresh();
        this.setChanged(true);
    }

    protected void addTrait(Decorator c) {
        Class<?> cClass = c.getClass();
        Decorator d = null;
        try {
            d = (Decorator)cClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleNewInstanceFailure(t, cClass);
        }
        if (d != null) {
            if (d instanceof PlaceMarker) {
                ((PlaceMarker)d).updateGpId(this.gpidSupport);
            }
            d.setInner(this.inUseModel.lastElement());
            this.inUseModel.addElement(d);
            this.setChanged(true);
        }
        this.refresh();
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            if (value instanceof EditablePiece) {
                this.setText(((EditablePiece)value).getDescription());
            } else {
                String s = value.getClass().getName();
                this.setText(s.substring(s.lastIndexOf(46) + 1));
            }
            return this;
        }
    }

    private static class TraitClipboard {
        private final String type;
        private final String state;

        public TraitClipboard(Decorator copy) {
            this.type = copy.myGetType();
            this.state = copy.myGetState();
        }

        public String getType() {
            return this.type;
        }

        public String getState() {
            return this.state;
        }
    }

    protected static class Ed
    extends JDialog {
        private static final long serialVersionUID = 1L;
        PieceEditor ed;

        private Ed(Frame owner, EditablePiece p) {
            super(owner, p.getDescription() + " properties", true);
            this.initialize(p);
        }

        private Ed(Dialog owner, EditablePiece p) {
            super(owner, p.getDescription() + " properties", true);
            this.initialize(p);
        }

        private void initialize(EditablePiece p) {
            this.ed = p.getEditor();
            this.setLayout((LayoutManager)new MigLayout("ins dialog,fill", "[]unrel[]", ""));
            this.add(this.ed.getControls(), "spanx 3,grow,push,wrap");
            JButton b = new JButton("Ok");
            b.addActionListener(evt -> this.dispose());
            this.add((Component)b, "tag ok");
            b = new JButton("Cancel");
            b.addActionListener(evt -> {
                this.ed = null;
                this.dispose();
            });
            this.add((Component)b, "tag cancel");
            if (p.getHelpFile() != null) {
                b = new JButton("Help");
                b.addActionListener(evt -> p.getHelpFile().showWindow(this));
                this.add((Component)b, "tag help");
            }
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        public PieceEditor getEditor() {
            return this.ed;
        }
    }
}

