/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.BasicModule;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.PlayerWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.JarArchive;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.UsernameAndPasswordDialog;
import VASSAL.tools.menu.MacOSXMenuManager;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.version.VersionUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.apache.commons.lang3.SystemUtils;

public class Player
extends Launcher {
    public static void main(String[] args) {
        new Player(args);
    }

    protected Player(String[] args) {
        super(args);
    }

    @Override
    protected MenuManager createMenuManager() {
        return SystemUtils.IS_OS_MAC_OSX ? new MacOSXMenuManager() : new PlayerMenuManager();
    }

    @Override
    protected void launch() throws IOException {
        if (this.lr.builtInModule) {
            GameModule.init(this.createModule(this.createDataArchive()));
            if (this.lr.autoext != null) {
                for (String ext : this.lr.autoext) {
                    this.createExtension(ext).build();
                }
            }
            this.createExtensionsLoader().addTo(GameModule.getGameModule());
            Localization.getInstance().translate();
            this.showWizardOrPlayerWindow(GameModule.getGameModule());
        } else {
            GameModule.init(this.createModule(this.createDataArchive()));
            this.createExtensionsLoader().addTo(GameModule.getGameModule());
            Localization.getInstance().translate();
            GameModule m = GameModule.getGameModule();
            if (this.lr.game != null) {
                m.getPlayerWindow().setVisible(true);
                m.getGameState().loadGameInBackground(this.lr.game);
            } else {
                this.showWizardOrPlayerWindow(m);
            }
        }
        if (this.ipc != null) {
            try {
                this.ipc.send(new AbstractLaunchAction.NotifyOpenModuleOk(this.lr));
            }
            catch (IOException e) {
                ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.socket_error", new Object[0]);
            }
        }
    }

    protected ExtensionsLoader createExtensionsLoader() {
        return new ExtensionsLoader();
    }

    protected ModuleExtension createExtension(String name) {
        return new ModuleExtension(new JarArchive(name));
    }

    protected DataArchive createDataArchive() throws IOException {
        if (this.lr.builtInModule) {
            return new JarArchive();
        }
        return new DataArchive(this.lr.module.getPath());
    }

    protected GameModule createModule(DataArchive archive) {
        return new BasicModule(archive);
    }

    private boolean isRealName() {
        String name = (String)GameModule.getGameModule().getPrefs().getValue("RealName");
        return name != null && !name.isBlank() && !name.equals(Resources.getString("Prefs.newbie"));
    }

    private void showWizardOrPlayerWindow(GameModule module) {
        Boolean showWizard = (Boolean)Prefs.getGlobalPrefs().getValue("welcomeWizard");
        if (Boolean.TRUE.equals(showWizard)) {
            module.getWizardSupport().showWelcomeWizard();
        } else {
            module.getPlayerWindow().setVisible(true);
            if (!this.isRealName()) {
                new UsernameAndPasswordDialog(module.getPlayerWindow()).setVisible(true);
            }
        }
    }

    private static class PlayerMenuManager
    extends MenuManager {
        private final MenuBarProxy menuBar = new MenuBarProxy();

        private PlayerMenuManager() {
        }

        @Override
        public JMenuBar getMenuBarFor(JFrame fc) {
            return fc instanceof PlayerWindow ? this.menuBar.createPeer() : null;
        }

        @Override
        public MenuBarProxy getMenuBarProxyFor(JFrame fc) {
            return fc instanceof PlayerWindow ? this.menuBar : null;
        }
    }

    public static class PromptLaunchAction
    extends LaunchAction {
        private static final long serialVersionUID = 1L;

        public PromptLaunchAction(ModuleManagerWindow mm) {
            super(mm, null);
            this.putValue("Name", Resources.getString("Main.play_module"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.promptForFile() == null) {
                return;
            }
            AbstractMetaData data = MetaDataFactory.buildMetaData(this.lr.module);
            if (data != null && Info.isModuleTooNew(data.getVassalVersion())) {
                ErrorDialog.show("Error.module_too_new", this.lr.module.getPath(), data.getVassalVersion(), Info.getVersion());
                return;
            }
            super.actionPerformed(e);
        }
    }

    public static class LaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public LaunchAction(ModuleManagerWindow mm, File module) {
            super(Resources.getString("Main.play_module_specific"), mm, Player.class.getName(), new LaunchRequest(LaunchRequest.Mode.LOAD, module));
            this.setEnabled(!editing.contains(module));
        }

        public LaunchAction(ModuleManagerWindow mm, File module, File saveGame) {
            super(Resources.getString("General.open"), mm, Player.class.getName(), new LaunchRequest(LaunchRequest.Mode.LOAD, module, saveGame));
            this.setEnabled(!editing.contains(module));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n;
            ModuleMetaData md;
            AbstractMetaData data = MetaDataFactory.buildMetaData(this.lr.module);
            if (data instanceof ModuleMetaData && VersionUtils.compareVersions((md = (ModuleMetaData)data).getVassalVersion(), "3.4") < 0) {
                if ("VASL".equals(md.getName())) {
                    ErrorDialog.show("Error.VASL_too_old", Info.getVersion());
                    return;
                }
                if ("VSQL".equals(md.getName())) {
                    ErrorDialog.show("Error.VSQL_too_old", Info.getVersion());
                    return;
                }
            }
            if (editing.contains(this.lr.module)) {
                return;
            }
            Integer count = (Integer)using.get(this.lr.module);
            File file = this.lr.module;
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            using.put(file, n);
            super.actionPerformed(e);
        }

        @Override
        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                @Override
                protected void done() {
                    super.done();
                    Integer count = AbstractLaunchAction.using.get(this.lr.module);
                    if (count == 1) {
                        AbstractLaunchAction.using.remove(this.lr.module);
                    } else {
                        count = count - 1;
                        AbstractLaunchAction.using.put(this.lr.module, count);
                    }
                }
            };
        }
    }
}

