/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.filechooser;

import VASSAL.configure.DirectoryConfigurer;
import VASSAL.tools.filechooser.DirectoryFileFilter;
import VASSAL.tools.filechooser.FileFilter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;

public abstract class FileChooser {
    protected Component parent;
    protected DirectoryConfigurer prefs;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;

    protected FileChooser(Component parent, DirectoryConfigurer pref) {
        this.parent = parent;
        this.prefs = pref;
    }

    public static FileChooser createFileChooser(Component parent) {
        return FileChooser.createFileChooser(parent, null);
    }

    public static FileChooser createFileChooser(Component parent, DirectoryConfigurer prefs) {
        return FileChooser.createFileChooser(parent, prefs, 0);
    }

    public static FileChooser createFileChooser(Component parent, DirectoryConfigurer prefs, int mode) {
        FileChooser fc = SystemUtils.IS_OS_MAC_OSX ? new NativeFileChooser(parent, prefs, mode) : (mode == 0 && SystemUtils.IS_OS_WINDOWS ? new NativeFileChooser(parent, prefs, mode) : new SwingFileChooser(parent, prefs, mode));
        return fc;
    }

    public abstract File getCurrentDirectory();

    public abstract void setCurrentDirectory(File var1);

    public abstract void rescanCurrentDirectory();

    public abstract File getSelectedFile();

    public abstract void setSelectedFile(File var1);

    public abstract String getDialogTitle();

    public abstract void setDialogTitle(String var1);

    public abstract int showOpenDialog(Component var1);

    public abstract int showSaveDialog(Component var1);

    public abstract FileFilter getFileFilter();

    public abstract void setFileFilter(FileFilter var1);

    public abstract void addChoosableFileFilter(FileFilter var1);

    public abstract boolean removeChoosableFileFilter(FileFilter var1);

    public abstract void resetChoosableFileFilters();

    public void selectDotSavFile() {
        Object name;
        int index;
        File file = this.getSelectedFile();
        if (file != null && (index = ((String)(name = file.getPath())).lastIndexOf(46)) > 0) {
            name = ((String)name).substring(0, index) + ".vsav";
            this.setSelectedFile(new File((String)name));
        }
    }

    public int showOpenDialog() {
        return this.showOpenDialog(this.parent);
    }

    public int showSaveDialog() {
        return this.showSaveDialog(this.parent);
    }

    protected void updateDirectoryPreference() {
        if (this.prefs != null && this.getCurrentDirectory() != null && !this.getCurrentDirectory().equals(this.prefs.getFileValue())) {
            this.prefs.setValue(this.getCurrentDirectory());
        }
    }

    private static class NativeFileChooser
    extends FileChooser {
        private File cur;
        private String title;
        private FileFilter filter;
        private int mode;

        public NativeFileChooser(Component parent, DirectoryConfigurer prefs, int mode) {
            super(parent, prefs);
            if (prefs != null && prefs.getFileValue() != null) {
                this.setCurrentDirectory(prefs.getFileValue());
            }
            this.mode = mode;
            if (mode == 1) {
                this.setFileFilter(new DirectoryFileFilter());
            }
        }

        @Override
        public File getCurrentDirectory() {
            return this.cur == null ? null : this.cur.getParentFile();
        }

        @Override
        public void setCurrentDirectory(File dir) {
            this.cur = dir;
        }

        @Override
        public void rescanCurrentDirectory() {
        }

        @Override
        public File getSelectedFile() {
            return this.cur;
        }

        @Override
        public void setSelectedFile(File file) {
            this.cur = file;
        }

        public int getFileSelectionMode() {
            return this.mode;
        }

        public void setFileSelectionMode(int mode) {
            this.mode = mode;
        }

        @Override
        public String getDialogTitle() {
            return this.title;
        }

        @Override
        public void setDialogTitle(String title) {
            this.title = title;
        }

        protected FileDialog awt_file_dialog_init(Component parent) {
            FileDialog fd;
            if (parent == null) {
                fd = new FileDialog((Frame)null, this.title);
            } else if (parent instanceof Dialog) {
                fd = new FileDialog((Dialog)parent, this.title);
            } else if (parent instanceof Frame) {
                fd = new FileDialog((Frame)parent, this.title);
            } else {
                Dialog d = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
                if (d != null) {
                    fd = new FileDialog(d, this.title);
                } else {
                    Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
                    if (f != null) {
                        fd = new FileDialog(f, this.title);
                    } else {
                        throw new IllegalArgumentException("parent is contained in neither a Dialog nor a Frame");
                    }
                }
            }
            fd.setModal(true);
            fd.setFilenameFilter(this.filter);
            if (this.cur != null) {
                if (this.cur.isDirectory()) {
                    fd.setDirectory(this.cur.getPath());
                } else {
                    fd.setDirectory(this.cur.getParent());
                    fd.setFile(this.cur.getName());
                }
            }
            return fd;
        }

        @Override
        public int showOpenDialog(Component parent) {
            int value;
            FileDialog fd = this.awt_file_dialog_init(parent);
            fd.setMode(0);
            System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(this.mode == 1));
            fd.setVisible(true);
            if (fd.getFile() != null) {
                this.cur = new File(fd.getDirectory(), fd.getFile());
                value = 0;
            } else {
                value = 1;
            }
            this.updateDirectoryPreference();
            return value;
        }

        @Override
        public int showSaveDialog(Component parent) {
            int value;
            FileDialog fd = this.awt_file_dialog_init(parent);
            fd.setMode(1);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                this.cur = new File(fd.getDirectory(), fd.getFile());
                value = 0;
            } else {
                value = 1;
            }
            this.updateDirectoryPreference();
            return value;
        }

        @Override
        public FileFilter getFileFilter() {
            return this.filter;
        }

        @Override
        public void setFileFilter(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public void addChoosableFileFilter(FileFilter filter) {
        }

        @Override
        public boolean removeChoosableFileFilter(FileFilter filter) {
            return false;
        }

        @Override
        public void resetChoosableFileFilters() {
        }
    }

    private static class SwingFileChooser
    extends FileChooser {
        private final JFileChooser fc = new JFileChooser();

        public SwingFileChooser(Component parent, DirectoryConfigurer prefs, int mode) {
            super(parent, prefs);
            if (prefs != null && prefs.getFileValue() != null) {
                this.setCurrentDirectory(prefs.getFileValue());
            }
            if (mode == 1) {
                this.setFileFilter(new DirectoryFileFilter());
            }
            this.fc.setFileSelectionMode(mode);
        }

        @Override
        public File getCurrentDirectory() {
            return this.fc.getCurrentDirectory();
        }

        @Override
        public void setCurrentDirectory(File dir) {
            this.fc.setCurrentDirectory(dir);
        }

        @Override
        public void rescanCurrentDirectory() {
            this.fc.rescanCurrentDirectory();
        }

        @Override
        public File getSelectedFile() {
            return this.fc.getSelectedFile();
        }

        @Override
        public void setSelectedFile(File file) {
            this.fc.setSelectedFile(file);
        }

        public int getFileSelectionMode() {
            return this.fc.getFileSelectionMode();
        }

        public void setFileSelectionMode(int mode) {
            this.fc.setFileSelectionMode(mode);
        }

        @Override
        public String getDialogTitle() {
            return this.fc.getDialogTitle();
        }

        @Override
        public void setDialogTitle(String title) {
            this.fc.setDialogTitle(title);
        }

        @Override
        public int showOpenDialog(Component parent) {
            int value = this.fc.showOpenDialog(parent);
            this.updateDirectoryPreference();
            return value;
        }

        @Override
        public int showSaveDialog(Component parent) {
            int value = this.fc.showSaveDialog(parent);
            if (value == 0 && this.getSelectedFile().exists() && 1 == JOptionPane.showConfirmDialog(parent, "Overwrite " + this.getSelectedFile().getName() + "?", "File Exists", 0)) {
                value = 1;
            }
            this.updateDirectoryPreference();
            return value;
        }

        @Override
        public FileFilter getFileFilter() {
            javax.swing.filechooser.FileFilter ff = this.fc.getFileFilter();
            return ff instanceof FileFilter ? (FileFilter)ff : null;
        }

        @Override
        public void setFileFilter(FileFilter filter) {
            this.fc.setFileFilter(filter);
        }

        @Override
        public void addChoosableFileFilter(FileFilter filter) {
            this.fc.addChoosableFileFilter(filter);
        }

        @Override
        public boolean removeChoosableFileFilter(FileFilter filter) {
            return this.fc.removeChoosableFileFilter(filter);
        }

        @Override
        public void resetChoosableFileFilters() {
            this.fc.resetChoosableFileFilters();
        }
    }
}

