/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.svg;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGImageUtils;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class SVGRenderer {
    private static final Logger logger = LoggerFactory.getLogger(SVGRenderer.class);
    private static final ImageRendererFactory rendFactory = new ConcreteImageRendererFactory();
    private final SVGDocument doc;
    private final float defaultW;
    private final float defaultH;
    private final Rasterizer r = new Rasterizer();
    private static final double DEGTORAD = Math.PI / 180;
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    public SVGRenderer(URL file, InputStream in) throws IOException {
        this(file.toString(), in);
    }

    public SVGRenderer(String file, InputStream in) throws IOException {
        this.doc = SVGImageUtils.getDocument(file, in);
        Dimension s = SVGImageUtils.getImageSize(this.doc);
        this.defaultW = s.width;
        this.defaultH = s.height;
    }

    public BufferedImage render() {
        return this.render(0.0, 1.0);
    }

    public BufferedImage render(double angle, double scale) {
        AffineTransform px = AffineTransform.getRotateInstance(angle * (Math.PI / 180), (double)this.defaultW / 2.0, (double)this.defaultH / 2.0);
        this.r.setTransform(px);
        px = new AffineTransform(px);
        px.scale(scale, scale);
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.defaultW, this.defaultH);
        Rectangle2D b = px.createTransformedShape(rect).getBounds2D();
        this.r.addTranscodingHint(Rasterizer.KEY_WIDTH, Float.valueOf((float)b.getWidth()));
        this.r.addTranscodingHint(Rasterizer.KEY_HEIGHT, Float.valueOf((float)b.getHeight()));
        try {
            this.r.transcode(new TranscoderInput((Document)this.doc), null);
            return this.r.getBufferedImage();
        }
        catch (BridgeException | TranscoderException e) {
            logger.error("", e);
            return null;
        }
    }

    public BufferedImage render(double angle, double scale, Rectangle2D aoi) {
        AffineTransform px = AffineTransform.getRotateInstance(angle * (Math.PI / 180), (double)this.defaultW / 2.0, (double)this.defaultH / 2.0);
        this.r.setTransform(px);
        px = new AffineTransform(px);
        px.scale(scale, scale);
        this.r.addTranscodingHint(Rasterizer.KEY_WIDTH, Float.valueOf((float)aoi.getWidth()));
        this.r.addTranscodingHint(Rasterizer.KEY_HEIGHT, Float.valueOf((float)aoi.getHeight()));
        this.r.addTranscodingHint(Rasterizer.KEY_AOI, aoi);
        try {
            this.r.transcode(new TranscoderInput((Document)this.doc), null);
            return this.r.getBufferedImage();
        }
        catch (BridgeException | TranscoderException e) {
            logger.error("", e);
            return null;
        }
    }

    private static class Rasterizer
    extends SVGAbstractTranscoder {
        private final DocumentLoader docLoader;
        private BufferedImage image;
        private AffineTransform xform;

        public Rasterizer() {
            this.docLoader = new DataArchiveDocumentLoader(this.userAgent);
        }

        protected BridgeContext createBridgeContext() {
            return new BridgeContext(this.userAgent, this.docLoader);
        }

        protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
            if (SystemUtils.IS_OS_MAC_OSX) {
                Node n;
                Element g = document.createElementNS("http://www.w3.org/2000/svg", "g");
                g.setAttributeNS(null, "transform", "rotate(0.000001)");
                Element svg = document.getDocumentElement();
                while ((n = svg.getFirstChild()) != null) {
                    g.appendChild(n);
                }
                svg.appendChild(g);
            }
            super.transcode(document, uri, output);
            int w = (int)((double)this.width + 0.5);
            int h = (int)((double)this.height + 0.5);
            ImageRenderer renderer = rendFactory.createStaticImageRenderer();
            renderer.updateOffScreen(w, h);
            if (this.xform != null) {
                this.curTxf.concatenate(this.xform);
            }
            renderer.setTransform(this.curTxf);
            renderer.setTree(this.root);
            this.root = null;
            Rectangle2D.Float raoi = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            try {
                renderer.repaint(this.curTxf.createInverse().createTransformedShape(raoi));
            }
            catch (NoninvertibleTransformException e) {
                throw new TranscoderException((Exception)e);
            }
            BufferedImage rend = renderer.getOffScreen();
            renderer = null;
            BufferedImage dest = ImageUtils.createCompatibleImage(w, h, !this.hints.containsKey((Object)KEY_BACKGROUND_COLOR));
            Graphics2D g2d = GraphicsUtil.createGraphics((BufferedImage)dest);
            if (this.hints.containsKey((Object)KEY_BACKGROUND_COLOR)) {
                Paint bgcolor = (Paint)this.hints.get((Object)KEY_BACKGROUND_COLOR);
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.setPaint(bgcolor);
                g2d.fillRect(0, 0, w, h);
            }
            if (rend != null) {
                g2d.drawRenderedImage(rend, new AffineTransform());
            }
            g2d.dispose();
            rend = null;
            this.writeImage(dest, output);
        }

        private void writeImage(BufferedImage image, TranscoderOutput output) {
            this.image = image;
        }

        public BufferedImage getBufferedImage() {
            return this.image;
        }

        public void setTransform(AffineTransform px) {
            this.xform = px;
        }
    }

    private static class DataArchiveDocumentLoader
    extends DocumentLoader {
        public DataArchiveDocumentLoader(UserAgent userAgent) {
            super(userAgent);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Document loadDocument(String uri) throws MalformedURLException, IOException {
            String file = new File(new URL(uri).getPath()).getName();
            DataArchive mda = GameModule.getGameModule().getDataArchive();
            try (InputStream inner = mda.getInputStream(file);){
                Document document;
                try (BufferedInputStream in = new BufferedInputStream(inner);){
                    document = this.loadDocument(uri, in);
                }
                return document;
            }
            catch (DOMException e) {
                throw new IOException(e);
            }
        }
    }
}

