/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.tilecache.ScaledTileTask;
import VASSAL.tools.image.tilecache.TileSlicer;
import VASSAL.tools.image.tilecache.TileTask;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.lang.Callback;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TileSlicerImpl
implements TileSlicer {
    @Override
    public void slice(BufferedImage src, String iname, String tpath, int tw, int th, ExecutorService exec, Callback<Void> progress) throws IOException {
        int sw = src.getWidth();
        int sh = src.getHeight();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        TaskMaker unscaled = TileTask::new;
        TileSlicerImpl.queueTileTasks(src, iname, tpath, 1, tw, th, sw, sh, unscaled, exec, futures);
        TaskMaker scaled = new TaskMaker(){
            private final GeneralFilter.Filter filter = new GeneralFilter.Lanczos3Filter();

            @Override
            public TileTask make(BufferedImage src, File f, int tx, int ty, int tw, int th, int dw, int dh) {
                return new ScaledTileTask(src, f, this.filter, tx, ty, tw, th, dw, dh);
            }
        };
        int div = 2;
        while (sw / div > 0 && sh / div > 0) {
            int n = sw / div;
            int dh = sh / div;
            TileSlicerImpl.queueTileTasks(src, iname, tpath, div, tw, th, n, dh, scaled, exec, futures);
            div <<= 1;
        }
        try {
            for (Future future : futures) {
                future.get();
                progress.receive(null);
            }
        }
        catch (InterruptedException | CancellationException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
    }

    protected static void queueTileTasks(BufferedImage src, String iname, String tpath, int div, int tw, int th, int dw, int dh, TaskMaker tm, ExecutorService exec, List<Future<Void>> futures) {
        int tcols = (int)Math.ceil((double)dw / (double)tw);
        int trows = (int)Math.ceil((double)dh / (double)th);
        for (int tx = 0; tx < tcols; ++tx) {
            for (int ty = 0; ty < trows; ++ty) {
                String tn = TileUtils.tileName(iname, tx, ty, div);
                File f = new File(tpath, tn);
                TileTask tt = tm.make(src, f, tx, ty, tw, th, dw, dh);
                futures.add(exec.submit(tt));
            }
        }
    }

    protected static interface TaskMaker {
        public TileTask make(BufferedImage var1, File var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

