/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.noteswindow.PrivateNotesController;
import VASSAL.build.module.noteswindow.SecretNotesController;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class NotesWindow
extends AbstractConfigurable
implements GameComponent,
CommandEncoder {
    protected JDialog frame;
    protected LaunchButton launch;
    protected TextConfigurer scenarioNotes;
    protected TextConfigurer publicNotes;
    protected PrivateNotesController privateNotes = new PrivateNotesController();
    protected SecretNotesController secretNotes = new SecretNotesController();
    protected static final String SCENARIO_NOTE_COMMAND_PREFIX = "NOTES\t";
    protected static final String PUBLIC_NOTE_COMMAND_PREFIX = "PNOTES\t";
    public static final String HOT_KEY = "hotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOLTIP = "tooltip";
    protected String lastSavedScenarioNotes;
    protected String lastSavedPublicNotes;

    public NotesWindow() {
        this.frame = new NotesDialog();
        this.frame.setTitle(Resources.getString("Notes.notes"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesWindow.this.captureState();
                NotesWindow.this.frame.setVisible(!NotesWindow.this.frame.isShowing());
            }
        };
        this.launch = new LaunchButton(Resources.getString("Notes.notes"), TOOLTIP, BUTTON_TEXT, HOT_KEY, ICON, al);
        this.launch.setAttribute(ICON, "/images/notes.gif");
        this.launch.setToolTipText(Resources.getString("Notes.notes"));
        this.frame.pack();
        this.setup(false);
    }

    protected void captureState() {
        this.lastSavedScenarioNotes = (String)this.scenarioNotes.getValue();
        this.lastSavedPublicNotes = (String)this.publicNotes.getValue();
        this.privateNotes.captureState();
        this.secretNotes.captureState();
    }

    public void cancel() {
        this.restoreState();
        this.privateNotes.restoreState();
        this.secretNotes.restoreState();
    }

    protected void restoreState() {
        this.scenarioNotes.setValue(this.lastSavedScenarioNotes);
        this.publicNotes.setValue(this.lastSavedPublicNotes);
    }

    protected void save() {
        NullCommand c = new NullCommand();
        if (!this.lastSavedScenarioNotes.equals(this.scenarioNotes.getValue())) {
            c.append(new SetScenarioNote(this.scenarioNotes.getValueString()));
        }
        if (!this.lastSavedPublicNotes.equals(this.publicNotes.getValue())) {
            c.append(new SetPublicNote(this.publicNotes.getValueString()));
        }
        c.append(this.privateNotes.save());
        c.append(this.secretNotes.save());
        GameModule.getGameModule().sendAndLog(c);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "NotesWindow");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON, HOT_KEY};
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.launch.setAttribute(name, value);
    }

    @Override
    public String getAttributeValueString(String name) {
        return this.launch.getAttributeValueString(name);
    }

    @Override
    public String encode(Command c) {
        Object s = null;
        if (c instanceof SetScenarioNote) {
            s = SCENARIO_NOTE_COMMAND_PREFIX + ((SetScenarioNote)c).msg;
        } else if (c instanceof SetPublicNote) {
            s = PUBLIC_NOTE_COMMAND_PREFIX + ((SetPublicNote)c).msg;
        } else {
            s = this.privateNotes.encode(c);
            if (s == null) {
                s = this.secretNotes.encode(c);
            }
        }
        return s;
    }

    @Override
    public Command decode(String command) {
        Command comm;
        if (command.startsWith(SCENARIO_NOTE_COMMAND_PREFIX)) {
            comm = new SetScenarioNote(command.substring(SCENARIO_NOTE_COMMAND_PREFIX.length()));
        } else if (command.startsWith(PUBLIC_NOTE_COMMAND_PREFIX)) {
            comm = new SetPublicNote(command.substring(PUBLIC_NOTE_COMMAND_PREFIX.length()));
        } else {
            comm = this.privateNotes.decode(command);
            if (comm == null) {
                comm = this.secretNotes.decode(command);
            }
        }
        return comm;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.NotesWindow.component_type");
    }

    @Override
    public void addTo(Buildable b) {
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this.privateNotes);
        GameModule.getGameModule().getGameState().addGameComponent(this.privateNotes);
        GameModule.getGameModule().addCommandEncoder(this.secretNotes);
        GameModule.getGameModule().getGameState().addGameComponent(this.secretNotes);
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this.privateNotes);
        GameModule.getGameModule().getGameState().removeGameComponent(this.privateNotes);
        GameModule.getGameModule().removeCommandEncoder(this.secretNotes);
        GameModule.getGameModule().getGameState().removeGameComponent(this.secretNotes);
    }

    @Override
    public void setup(boolean show) {
        this.launch.setEnabled(show);
        if (!show) {
            this.scenarioNotes.setValue("");
            this.publicNotes.setValue("");
        }
    }

    @Override
    public Command getRestoreCommand() {
        SetScenarioNote c = new SetScenarioNote(this.scenarioNotes.getValueString());
        c.append(new SetPublicNote(this.publicNotes.getValueString()));
        c.append(this.privateNotes.getRestoreCommand());
        c.append(this.secretNotes.getRestoreCommand());
        return c;
    }

    protected class NotesDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        protected NotesDialog() {
            super(GameModule.getGameModule().getPlayerWindow());
            this.initComponents();
            this.setLocationRelativeTo(this.getOwner());
        }

        protected void initComponents() {
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NotesWindow.this.cancel();
                    NotesDialog.this.setVisible(false);
                }
            });
            NotesWindow.this.scenarioNotes = new TextConfigurer(null, null);
            NotesWindow.this.publicNotes = new TextConfigurer(null, null);
            JTabbedPane tab = new JTabbedPane();
            this.add(tab);
            Box b = Box.createVerticalBox();
            b.add(new JLabel(Resources.getString("Notes.visible_to_all")));
            b.add(NotesWindow.this.scenarioNotes.getControls());
            tab.addTab(Resources.getString("Notes.scenario"), b);
            b = Box.createVerticalBox();
            b.add(new JLabel(Resources.getString("Notes.visible_to_all")));
            b.add(NotesWindow.this.publicNotes.getControls());
            tab.addTab(Resources.getString("Notes.public"), b);
            tab.addTab(Resources.getString("Notes.private"), NotesWindow.this.privateNotes.getControls());
            tab.addTab(Resources.getString("Notes.delayed"), NotesWindow.this.secretNotes.getControls());
            JPanel p = new JPanel();
            JButton saveButton = new JButton(Resources.getString("General.save"));
            p.add(saveButton);
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotesWindow.this.save();
                    NotesDialog.this.setVisible(false);
                }
            });
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotesWindow.this.cancel();
                    NotesDialog.this.setVisible(false);
                }
            });
            p.add(cancelButton);
            this.add(p);
        }
    }

    protected class SetScenarioNote
    extends Command {
        protected String msg;

        protected SetScenarioNote(String s) {
            this.msg = s;
        }

        @Override
        protected void executeCommand() {
            NotesWindow.this.scenarioNotes.setValue(this.msg);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    protected class SetPublicNote
    extends Command {
        protected String msg;

        protected SetPublicNote(String s) {
            this.msg = s;
        }

        @Override
        protected void executeCommand() {
            NotesWindow.this.publicNotes.setValue(this.msg);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((NotesWindow)c).launch.getAttributeValueString(NotesWindow.ICON));
        }
    }
}

