/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PlayerRoster;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ObscurableOptions
implements CommandEncoder,
GameComponent {
    private static final ObscurableOptions instance = new ObscurableOptions();
    public static final String COMMAND_ID = "UNMASK\t";
    public static final String PREFS_KEY = "OpponentUnmaskable";
    private List<String> allowed = new ArrayList<String>();
    private Boolean override;

    private ObscurableOptions() {
    }

    public ObscurableOptions(String settings) {
        this();
        if (settings != null && settings.length() > 0) {
            this.decodeOptions(settings);
        } else {
            this.decodeOptions(ObscurableOptions.getInstance().encodeOptions());
        }
    }

    public static ObscurableOptions getInstance() {
        return instance;
    }

    public void allowSome(String preferencesPrompt) {
        BooleanConfigurer c = new BooleanConfigurer(PREFS_KEY, preferencesPrompt);
        GameModule.getGameModule().getPrefs().addOption(c);
        c.addPropertyChangeListener(evt -> {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                ObscurableOptions.getInstance().allow(GameModule.getUserId());
                String side = PlayerRoster.getMySide();
                if (side != null) {
                    ObscurableOptions.getInstance().allow(side);
                }
            } else {
                ObscurableOptions.getInstance().disallow(GameModule.getUserId());
                String side = PlayerRoster.getMySide();
                if (side != null) {
                    ObscurableOptions.getInstance().disallow(side);
                }
            }
            GameModule.getGameModule().getServer().sendToOthers(new SetAllowed(ObscurableOptions.instance.allowed));
        });
        if (Boolean.TRUE.equals(c.getValue())) {
            this.allow(GameModule.getUserId());
        } else {
            this.disallow(GameModule.getUserId());
        }
    }

    public void setPrompt(String preferencesPrompt) {
        Configurer c = GameModule.getGameModule().getPrefs().getOption(PREFS_KEY);
        if (c != null) {
            c.setName(preferencesPrompt);
        }
    }

    public void allowAll() {
        this.override = Boolean.TRUE;
    }

    public void allowNone() {
        this.override = Boolean.FALSE;
    }

    public void allow(String id) {
        if (!this.allowed.contains(id)) {
            this.allowed.add(id);
        }
    }

    public void disallow(String id) {
        this.allowed.remove(id);
    }

    @Override
    public Command decode(String command) {
        if (command.startsWith(COMMAND_ID)) {
            command = command.substring(COMMAND_ID.length());
            ArrayList<String> l = new ArrayList<String>();
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\t');
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            return new SetAllowed(l);
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof SetAllowed) {
            List<String> l = ((SetAllowed)c).getAllowedIds();
            if (l.isEmpty()) {
                return COMMAND_ID;
            }
            SequenceEncoder se = new SequenceEncoder('\t');
            for (String s : l) {
                se.append(s);
            }
            return COMMAND_ID + se.getValue();
        }
        return null;
    }

    public String encodeOptions() {
        SequenceEncoder se = new SequenceEncoder('|');
        if (this.override == null) {
            se.append("");
        } else {
            se.append(this.override);
        }
        se.append(this.allowed.size());
        for (String who : this.allowed) {
            se.append(who);
        }
        return se.getValue();
    }

    public void decodeOptions(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '|');
        String setting = sd.nextToken("");
        this.override = setting.length() == 0 ? null : Boolean.valueOf(setting.equals("true"));
        int count = sd.nextInt(0);
        this.allowed.clear();
        for (int i = 0; i < count; ++i) {
            setting = sd.nextToken("");
            if (setting.length() <= 0) continue;
            this.allowed.add(setting);
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new SetAllowed(this.allowed);
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.allowed.clear();
        } else if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(PREFS_KEY))) {
            this.allow(GameModule.getUserId());
        }
    }

    public boolean isUnmaskable(String id) {
        return this.override != null ? this.override.booleanValue() : this.allowed.contains(id);
    }

    public static class SetAllowed
    extends Command {
        private final List<String> allowed;

        public SetAllowed(List<String> allowed) {
            this.allowed = allowed;
        }

        @Deprecated(since="2020-08-06", forRemoval=true)
        public SetAllowed(Vector<String> allowed) {
            ProblemDialog.showDeprecated("2020-08-06");
            this.allowed = allowed;
        }

        public List<String> getAllowedIds() {
            return this.allowed;
        }

        @Override
        protected void executeCommand() {
            ObscurableOptions.getInstance().override = null;
            ObscurableOptions.getInstance().allowed = this.allowed;
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

