/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.command.Command;
import VASSAL.i18n.Resources;

public class SynchCommand
extends Command {
    private Player recipient;
    private ChatServerConnection client;

    public SynchCommand(Player p, ChatServerConnection client) {
        this.recipient = p;
        this.client = client;
    }

    public Player getPlayer() {
        return this.recipient;
    }

    @Override
    protected void executeCommand() {
        if (this.recipient != null) {
            GameModule.getGameModule().warn(Resources.getString("Server.sending_game_info", this.recipient.getName()));
            Command synch = GameModule.getGameModule().getGameState().getRestoreCommand();
            if (synch != null) {
                this.client.sendTo(this.recipient, synch);
            }
        }
    }

    @Override
    protected Command myUndoCommand() {
        return null;
    }

    @Override
    public boolean isLoggable() {
        return false;
    }
}

