/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.messageboard;

import VASSAL.chat.messageboard.Message;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class MessageViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable msgTable;
    private DefaultTableModel model;
    private JTextArea msgText;
    private List<Message> msgList = new ArrayList<Message>();

    public MessageViewer() {
        this.initComponents();
    }

    public void setMessages(Enumeration<Message> msgEnum) {
        this.msgList.clear();
        this.msgText.setText("");
        Vector rows = new Vector();
        Vector<String> names = new Vector<String>();
        names.addElement(Resources.getString("Chat.sender"));
        names.addElement(Resources.getString("Chat.date"));
        while (msgEnum.hasMoreElements()) {
            Message msg = msgEnum.nextElement();
            this.msgList.add(msg);
            Vector<String> cols = new Vector<String>();
            cols.addElement(msg.getSender());
            cols.addElement(Resources.formatDate(msg.getDate()));
            rows.addElement(cols);
        }
        this.model = new DefaultTableModel(rows, names);
        this.msgTable.setModel(this.model);
        if (!this.msgList.isEmpty()) {
            this.msgTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initComponents() {
        JSplitPane split = new JSplitPane(1);
        this.model = new DefaultTableModel(new Object[]{Resources.getString("Chat.sender"), Resources.getString("Chat.date")}, 0);
        this.msgTable = new JTable(this.model);
        this.msgTable.getSelectionModel().addListSelectionListener(new ShowMsgText());
        JScrollPane scroll = new JScrollPane(this.msgTable);
        split.add(scroll);
        this.msgText = new JTextArea(10, 25);
        this.msgText.setLineWrap(true);
        this.msgText.setWrapStyleWord(true);
        this.msgText.setEditable(false);
        scroll = new JScrollPane(this.msgText);
        scroll.setBorder(new TitledBorder(Resources.getString("Chat.message")));
        split.add(scroll);
        this.add(split);
    }

    private class ShowMsgText
    implements ListSelectionListener {
        private ShowMsgText() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            int index = MessageViewer.this.msgTable.getSelectedRow();
            if (index >= 0 && index < MessageViewer.this.msgList.size()) {
                MessageViewer.this.msgText.setText(MessageViewer.this.msgList.get(index).getText());
            } else {
                MessageViewer.this.msgText.setText("");
            }
        }
    }
}

