/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.CgiServerStatus;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeServerInfo;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

public class SocketNodeClient
extends NodeClient
implements SocketWatcher {
    private SocketHandler sender;
    protected NodeServerInfo serverInfo;

    public SocketNodeClient(String moduleName, String playerId, CommandEncoder encoder, NodeServerInfo serverInfo, MessageBoard msgSvr, WelcomeMessageServer welcomer) {
        super(moduleName, playerId, encoder, msgSvr, welcomer);
        this.serverInfo = serverInfo;
        this.serverStatus = new CgiServerStatus();
    }

    public SocketNodeClient(String moduleName, String playerId, CommandEncoder encoder, final String host, final int port, MessageBoard msgSvr, WelcomeMessageServer welcomer) {
        this(moduleName, playerId, encoder, new NodeServerInfo(){

            @Override
            public String getHostName() {
                return host;
            }

            @Override
            public int getPort() {
                return port;
            }
        }, msgSvr, welcomer);
    }

    @Override
    public void send(String command) {
        this.sender.writeLine(command);
    }

    @Override
    protected void initializeConnection() throws UnknownHostException, IOException {
        Socket s = new Socket(this.serverInfo.getHostName(), this.serverInfo.getPort());
        this.sender = new SocketHandler(s, this);
        this.sender.start();
    }

    @Override
    protected void closeConnection() {
        SocketHandler s = this.sender;
        this.sender = null;
        s.close();
    }

    @Override
    public boolean isConnected() {
        return this.sender != null;
    }

    @Override
    public void socketClosed(SocketHandler handler) {
        if (this.sender != null) {
            this.propSupport.firePropertyChange("Status", null, Resources.getString("Server.lost_connection"));
            this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
            this.sender = null;
        }
    }

    @Override
    public void handleMessage(String msg) {
        this.handleMessageFromServer(msg);
    }

    public void updateConfig(Properties params) {
    }
}

