/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.command.MovePiece;
import VASSAL.counters.GamePiece;
import java.awt.Point;

public class MoveTracker {
    private String oldMapId;
    private Point oldPosition;
    private String oldUnderneathId;
    private GamePiece piece;

    public MoveTracker(GamePiece piece) {
        this.piece = piece;
        this.oldMapId = this.getMapId();
        this.oldPosition = piece.getPosition();
        this.oldUnderneathId = this.getUnderneathId();
    }

    private String getUnderneathId() {
        int index;
        String id = null;
        if (this.piece.getParent() != null && (index = this.piece.getParent().indexOf(this.piece)) > 0) {
            id = this.piece.getParent().getPieceAt(index - 1).getId();
        }
        return id;
    }

    private String getMapId() {
        return this.piece.getMap() == null ? null : this.piece.getMap().getIdentifier();
    }

    public Command getMoveCommand() {
        return new MovePiece(this.piece.getId(), this.getMapId(), this.piece.getPosition(), this.getUnderneathId(), this.oldMapId, this.oldPosition, this.oldUnderneathId, GameModule.getUserId());
    }
}

