/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ZipUpdater;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ModuleUpdaterDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public ModuleUpdaterDialog(Frame owner) throws HeadlessException {
        super(owner, false);
        this.setTitle("Module Updater");
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        final FileConfigurer fileConfig = new FileConfigurer(null, "File containing older version:  ");
        this.add(fileConfig.getControls());
        Box b = Box.createHorizontalBox();
        final JButton saveButton = new JButton("Create Updater");
        saveButton.setEnabled(false);
        fileConfig.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                saveButton.setEnabled(fileConfig.getValue() != null);
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser fc = GameModule.getGameModule().getFileChooser();
                if (fc.showSaveDialog(ModuleUpdaterDialog.this.getOwner()) != 0) {
                    return;
                }
                File output = fc.getSelectedFile();
                ZipUpdater updater = null;
                try {
                    updater = new ZipUpdater((File)fileConfig.getValue());
                    updater.createUpdater(new File(GameModule.getGameModule().getArchiveWriter().getName()), output);
                }
                catch (IOException e1) {
                    String msg = e1.getMessage();
                    if (msg == null) {
                        msg = "Unable to create updater.";
                    }
                    JOptionPane.showMessageDialog(ModuleUpdaterDialog.this, msg, "Error writing updater", 0);
                }
            }
        });
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleUpdaterDialog.this.dispose();
            }
        });
        JButton helpButton = new JButton("Help");
        this.add(b);
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "ModuleUpdater.htm"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        helpButton.addActionListener(new ShowHelpAction(hf.getContents(), null));
        b.add(saveButton);
        b.add(helpButton);
        b.add(cancelButton);
        this.add(b);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

