/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.CRC32;

public class CRCUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static long getCRC(List<File> files) throws IOException {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        for (File file : files) {
            CRCUtils.buildCRC(file, crc, buffer);
        }
        return crc.getValue();
    }

    private static void buildCRC(File file, CRC32 crc, byte[] buffer) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            CRCUtils.buildCRC(in, crc, buffer);
        }
    }

    private static void buildCRC(InputStream in, CRC32 crc, byte[] buffer) throws IOException {
        int count;
        while ((count = in.read(buffer)) >= 0) {
            crc.update(buffer, 0, count);
        }
    }
}

