/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.AudioClip;
import VASSAL.tools.AudioSystemClip;
import VASSAL.tools.ImprovedAveragingScaleFilter;
import VASSAL.tools.Mp3AudioClip;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ZipArchive;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import org.apache.xmlgraphics.image.loader.ImageSource;

public class DataArchive
extends SecureClassLoader
implements Closeable {
    protected FileArchive archive;
    protected List<DataArchive> extensions = new ArrayList<DataArchive>();
    private final Map<String, AudioClip> soundCache = new HashMap<String, AudioClip>();
    protected SortedSet<String> localImages = null;
    public static final String IMAGE_DIR = "images/";
    protected String imageDir = "images/";
    public static final String SOUND_DIR = "sounds/";
    protected String soundDir = "sounds/";
    public static final String ICON_DIR = "icons/";
    private static final CodeSource cs = new CodeSource(null, (Certificate[])null);
    @Deprecated(since="2020-08-06", forRemoval=true)
    public static final String SOUNDS_DIR = "sounds/";
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected String soundsDir = "sounds/";
    @Deprecated(since="2020-08-06", forRemoval=true)
    private final Map<String, ImageSource> imageSources = new HashMap<String, ImageSource>();
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected String[] imageNames;

    protected DataArchive() {
        super(DataArchive.class.getClassLoader());
    }

    public DataArchive(String zipName, String imageDir) throws IOException {
        this();
        this.archive = new ZipArchive(zipName);
        this.imageDir = imageDir;
    }

    public DataArchive(String zipName) throws IOException {
        this(zipName, IMAGE_DIR);
    }

    @Override
    public String getName() {
        return this.archive == null ? "data archive" : this.archive.getName();
    }

    public FileArchive getArchive() {
        return this.archive;
    }

    public String getImagePrefix() {
        return this.imageDir;
    }

    public AudioClip getCachedAudioClip(String name) throws IOException {
        String path = this.soundDir + name;
        AudioClip clip = this.soundCache.get(path);
        if (clip == null) {
            if (name.toLowerCase().endsWith(".mp3")) {
                clip = new Mp3AudioClip(path);
            } else {
                try (InputStream stream = this.getInputStream(path);){
                    clip = new AudioSystemClip(stream);
                }
            }
            this.soundCache.put(path, clip);
        }
        return clip;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public InputStream getImageInputStream(String fileName) throws IOException, FileNotFoundException {
        ProblemDialog.showDeprecated("2020-08-06");
        if (fileName.startsWith("/")) {
            InputStream in2 = this.getClass().getResourceAsStream(fileName);
            if (in2 != null) {
                return in2;
            }
            throw new FileNotFoundException("Resource not found: " + fileName);
        }
        try {
            return this.getInputStream(this.imageDir + fileName);
        }
        catch (FileNotFoundException in2) {
            try {
                return this.getInputStream(this.imageDir + fileName + ".gif");
            }
            catch (FileNotFoundException in2) {
                InputStream in3 = this.getClass().getResourceAsStream("/" + this.imageDir + fileName + ".gif");
                if (in3 != null) {
                    return in3;
                }
                throw new FileNotFoundException("'" + this.imageDir + fileName + "' not found in " + this.getName());
            }
        }
    }

    public InputStream getInputStream(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            InputStream in = this.getClass().getResourceAsStream(fileName);
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException("Resource not found: " + fileName);
        }
        InputStream in = this.getInputStreamImpl(fileName);
        if (in != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream("/" + fileName);
        if (in != null) {
            return in;
        }
        in = this.getInputStreamImpl(fileName + ".gif");
        if (in != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream("/" + fileName + ".gif");
        if (in != null) {
            return in;
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    private InputStream getInputStreamImpl(String fileName) throws IOException {
        if (this.archive != null && this.archive.contains(fileName)) {
            return this.archive.getInputStream(fileName);
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getInputStream(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }

    public URL getURL() throws IOException {
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        return URLUtils.toJarURL(this.archive.getName());
    }

    public URL getURL(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            return this.getClass().getResource(fileName);
        }
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        if (this.archive.contains(fileName)) {
            return new URL(this.getURL(), fileName);
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getURL(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public URL getImageURL(String fileName) throws IOException, FileNotFoundException {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getURL(fileName);
    }

    public boolean contains(String fileName) throws IOException {
        if (this.archive == null) {
            return false;
        }
        return this.archive.contains(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.revert();
            this.archive.close();
        }
    }

    public String[] getImageNames() {
        SortedSet<String> s = this.getImageNameSet();
        return s.toArray(new String[0]);
    }

    public SortedSet<String> getImageNameSet() {
        TreeSet<String> s = new TreeSet<String>();
        this.getImageNamesRecursively(s);
        return s;
    }

    protected void getImageNamesRecursively(SortedSet<String> s) {
        if (this.localImages == null) {
            this.localImages = this.getLocalImageNames();
        }
        s.addAll(this.localImages);
        for (DataArchive ext : this.extensions) {
            ext.getImageNamesRecursively(s);
        }
    }

    protected SortedSet<String> getLocalImageNames() {
        TreeSet<String> s = new TreeSet<String>();
        if (this.archive != null) {
            try {
                for (String filename : this.archive.getFiles("images")) {
                    s.add(filename.substring(this.imageDir.length()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    public void addExtension(DataArchive ext) {
        this.extensions.add(ext);
    }

    public ArchiveWriter getWriter() {
        if (this instanceof ArchiveWriter) {
            return (ArchiveWriter)this;
        }
        for (DataArchive ext : this.extensions) {
            ArchiveWriter writer = ext.getWriter();
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            c = this.findLoadedClass(name);
        }
        if (c == null) {
            return this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection p = super.getPermissions(codesource);
        p.add(new AllPermission());
        return p;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] data;
        String slashname = name.replace('.', '/');
        try (InputStream stream = this.getInputStream(slashname + ".class");){
            data = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Unable to load class " + name, e);
        }
        int minor = data[4] << 8 | data[5];
        int major = data[6] << 8 | data[7];
        if (major > 55 || major == 55 && minor != 0) {
            ProblemDialog.showDisableable(2, null, null, (Object)cs, Resources.getString("Dialogs.incompatible.title"), Resources.getString("Dialogs.incompatible.heading"), Resources.getString("Dialogs.incompatible.message", name) + "\n\n" + Resources.getString("Dialogs.check_for_updated_module"));
        }
        return this.defineClass(name, data, 0, data.length, cs);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public boolean addImageSource(String name, ImageSource src) {
        ProblemDialog.showDeprecated("2020-08-06");
        if (!this.imageSources.containsKey(name)) {
            this.imageSources.put(name, src);
            this.localImages = null;
            return true;
        }
        return false;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void removeImageSource(String name) {
        ProblemDialog.showDeprecated("2020-08-06");
        this.imageSources.remove(name);
        this.localImages = null;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Dimension getImageSize(String name) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        if (name.toLowerCase().endsWith(".svg")) {
            return SVGImageUtils.getImageSize(name, this.getImageInputStream(name));
        }
        return ImageUtils.getImageSize(name, this.getImageInputStream(name));
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public BufferedImage getImage(String name) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        if (name.toLowerCase().endsWith(".svg")) {
            return new SVGRenderer(this.getURL(name), this.getImageInputStream(name)).render();
        }
        return ImageUtils.getImage(name, this.getImageInputStream(name));
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected boolean isNameCacheStale() {
        ProblemDialog.showDeprecated("2020-08-06");
        return true;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected SortedSet<String> setOfImageNames() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getImageNameSet();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void unCacheImage(String file) {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void unCacheImage(Image im) {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void clearTransformedImageCache() {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void clearScaledImageCache() {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image getCachedImage(String name) {
        ProblemDialog.showDeprecated("2020-08-06");
        return Op.load(name).getImage();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image getTransformedImage(Image base, double scale, double theta) {
        ProblemDialog.showDeprecated("2020-08-06");
        return Op.rotateScale(Op.load(ImageUtils.toBufferedImage(base)), theta, scale).getImage();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image getTransformedImage(Image base, double scale, double theta, boolean forceSmoothing) {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getTransformedImage(base, scale, theta);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image getScaledImage(Image base, double scale, boolean reversed, boolean forceSmoothing) {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getTransformedImage(base, scale, reversed ? 180.0 : 0.0);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image getScaledImage(Image base, double scale) {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getTransformedImage(base, scale, 0.0, true);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static Image findImage(File zip, String file) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        return DataArchive.getImage(DataArchive.getFileStream(zip, file));
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static Image findImage(File dir, String zip, String file) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        if (new File(dir, zip).exists()) {
            return DataArchive.getImage(DataArchive.getFileStream(dir, zip, file));
        }
        if (new File(dir, file).exists()) {
            return Toolkit.getDefaultToolkit().getImage(dir.getPath() + File.separatorChar + file);
        }
        throw new IOException("Image " + file + " not found in " + dir + File.separator + zip);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static InputStream getFileStream(File zip, String file) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        try {
            ZipFile z = new ZipFile(zip);
            return z.getInputStream(z.getEntry(file));
        }
        catch (Exception e) {
            throw new IOException("Couldn't locate " + file + " in " + zip.getName() + ": " + e.getMessage());
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static InputStream getFileStream(File dir, String zipName, String file) {
        ProblemDialog.showDeprecated("2020-08-06");
        try {
            if (new File(dir, zipName).exists()) {
                ZipFile zip = new ZipFile(new File(dir, zipName));
                return zip.getInputStream(zip.getEntry(file));
            }
            return new FileInputStream(new File(dir, file));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public InputStream getFileStream(String fileName) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getInputStream(fileName);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static Image getImage(InputStream in) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        return ImageUtils.getImage("", in);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public String getArchiveURL() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.archive != null ? "jar:file://" + this.archive.getName() + "!/" : "";
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static byte[] getBytes(InputStream in) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        return IOUtils.toByteArray((InputStream)in);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected void listImageNames(Collection l) {
        ProblemDialog.showDeprecated("2020-08-06");
        l.addAll(this.setOfImageNames());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static Rectangle getImageBounds(Image im) {
        ProblemDialog.showDeprecated("2020-08-06");
        ImageIcon icon = new ImageIcon(im);
        return new Rectangle(-icon.getIconWidth() / 2, -icon.getIconHeight() / 2, icon.getIconWidth(), icon.getIconHeight());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image improvedScaling(Image img, int width, int height) {
        ProblemDialog.showDeprecated("2020-08-06");
        ImprovedAveragingScaleFilter filter = new ImprovedAveragingScaleFilter(img.getWidth(null), img.getHeight(null), width, height);
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }
}

