/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowableUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThrowableUtils.class);

    private ThrowableUtils() {
    }

    public static <T extends Throwable> T getAncestor(Class<T> cl, Throwable t) {
        for (Throwable c = t.getCause(); c != null; c = c.getCause()) {
            if (!cl.isInstance(c)) continue;
            return (T)((Throwable)cl.cast(c));
        }
        return null;
    }

    public static <T extends Throwable> T getRecent(Class<T> cl, Throwable t) {
        if (cl.isInstance(t)) {
            return (T)((Throwable)cl.cast(t));
        }
        return ThrowableUtils.getAncestor(cl, t);
    }

    public static <T extends Throwable> void throwAncestor(Class<T> cl, Throwable t) throws T {
        T ancestor = ThrowableUtils.getAncestor(cl, t);
        if (ancestor != null) {
            ThrowableUtils.throwMe(cl, t);
        }
    }

    public static <T extends Throwable> void throwRecent(Class<T> cl, Throwable t) throws T {
        if (cl.isInstance(t)) {
            ThrowableUtils.throwMe(cl, t);
        } else {
            ThrowableUtils.throwAncestor(cl, t);
        }
    }

    private static <T extends Throwable> void throwMe(Class<T> cl, Throwable t) throws T {
        Throwable toThrow = null;
        try {
            toThrow = (Throwable)cl.cast(cl.getConstructor(new Class[0]).newInstance(t));
        }
        catch (Throwable ignore) {
            logger.warn("ignored", ignore);
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static String getStackTrace(Throwable thrown) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

