/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.concurrent.DaemonThreadFactory;
import VASSAL.tools.image.FallbackImageTypeConverter;
import VASSAL.tools.image.ImageIOImageLoader;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.tilecache.FileArchiveImageTiler;
import VASSAL.tools.image.tilecache.TileSlicer;
import VASSAL.tools.image.tilecache.TileSlicerImpl;
import VASSAL.tools.io.TemporaryFileFactory;
import VASSAL.tools.io.ZipArchive;
import VASSAL.tools.lang.Callback;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileImageTiler {
    private static final Logger logger = LoggerFactory.getLogger(ZipFileImageTiler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            logger.info("Starting");
            System.setProperty("java.awt.headless", "true");
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable thrown) {
                    logger.error(thread.getName(), thrown);
                }
            });
            String zpath = args[0];
            String tpath = args[1];
            int tw = Integer.parseInt(args[2]);
            int th = Integer.parseInt(args[3]);
            ArrayList<String> pl = new ArrayList<String>();
            try (BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));){
                String s;
                while ((s = stdin.readLine()) != null) {
                    pl.add(s);
                }
            }
            catch (IOException e) {
                logger.error("Error while reading image paths from stdin", (Throwable)e);
            }
            String[] ipaths = pl.toArray(new String[0]);
            Runtime runtime = Runtime.getRuntime();
            ThreadPoolExecutor exec = new ThreadPoolExecutor(runtime.availableProcessors(), runtime.availableProcessors() + 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory(ZipFileImageTiler.class.getSimpleName()));
            TemporaryFileFactory tfac = () -> Files.createTempFile(Path.of(tpath, new String[0]), "img_", "", new FileAttribute[0]).toFile();
            FallbackImageTypeConverter itc = new FallbackImageTypeConverter(tfac);
            ImageIOImageLoader loader = new ImageIOImageLoader(itc);
            TileSlicerImpl slicer = new TileSlicerImpl();
            FileArchiveImageTiler tiler = new FileArchiveImageTiler();
            String portProp = System.getProperty("VASSAL.port");
            if (portProp != null) {
                ZipFileImageTiler.writeToSocket(portProp, zpath, tiler, tpath, tw, th, ipaths, exec, loader, slicer);
            } else {
                ZipFileImageTiler.writeToSystemErr(zpath, tiler, tpath, tw, th, ipaths, exec, loader, slicer);
            }
        }
        finally {
            logger.info("Exiting");
        }
    }

    private static void writeToSystemErr(String zpath, FileArchiveImageTiler tiler, String tpath, int tw, int th, String[] ipaths, ExecutorService exec, ImageLoader loader, TileSlicer slicer) {
        ZipFileImageTiler.writeToOutputStream(System.err, zpath, tiler, tpath, tw, th, ipaths, exec, loader, slicer);
    }

    private static void writeToSocket(String portProp, String zpath, FileArchiveImageTiler tiler, String tpath, int tw, int th, String[] ipaths, ExecutorService exec, ImageLoader loader, TileSlicer slicer) {
        InetAddress lo;
        int port = Integer.parseInt(portProp);
        try {
            lo = InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            logger.error("Could not determine local IP address", (Throwable)e);
            return;
        }
        try (Socket sock = new Socket(lo, port);){
            sock.shutdownInput();
            ZipFileImageTiler.writeToOutputStream(sock.getOutputStream(), zpath, tiler, tpath, tw, th, ipaths, exec, loader, slicer);
        }
        catch (IOException e) {
            logger.error("Error while setting up socket", (Throwable)e);
        }
    }

    private static void writeToOutputStream(OutputStream os, String zpath, FileArchiveImageTiler tiler, String tpath, int tw, int th, String[] ipaths, ExecutorService exec, ImageLoader loader, TileSlicer slicer) {
        try (final DataOutputStream out = new DataOutputStream(os);){
            Callback<String> imageL = new Callback<String>(){

                @Override
                public void receive(String ipath) throws IOException {
                    out.writeByte(1);
                    out.writeUTF(ipath);
                    out.flush();
                }
            };
            Callback<Void> tileL = new Callback<Void>(){

                @Override
                public void receive(Void obj) throws IOException {
                    out.writeByte(2);
                    out.flush();
                }
            };
            Callback<Void> doneL = new Callback<Void>(){

                @Override
                public void receive(Void obj) throws IOException {
                    out.writeByte(3);
                    out.flush();
                }
            };
            try (ZipArchive fa = new ZipArchive(zpath);){
                tiler.run(fa, tpath, tw, th, ipaths, exec, loader, slicer, imageL, tileL, doneL);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        catch (IOException e) {
            logger.error("Error while writing to outputstream {}", (Object)os, (Object)e);
        }
    }
}

