/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports.adc2;

import VASSAL.build.GameModule;
import VASSAL.tools.filechooser.BMPFileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.ImportAction;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Utils;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolSet
extends Importer {
    private static final int OLD_SYMBOL_SET_FORMAT = 253;
    private static final Logger log = LoggerFactory.getLogger(SymbolSet.class);
    private static final float[][] THREE_BAND_MATRIX = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f, 255.0f}};
    private static final float[][] ONE_BAND_MATRIX = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.0f}, {-255.0f, 255.0f}};
    private SymbolData[] gamePieceData;
    private SymbolData[] mapBoardData;
    private int[] mapBoardSymbolSize;
    private SymbolData[] maskData = null;
    private Shape symbolShape;
    private static final int zoomLevel = 2;
    private boolean ignoreMask;
    private boolean isCardSet;
    private int header;
    BufferedImage underlay;

    private static BufferedImage generateAlphaMask(BufferedImage img) {
        BandCombineOp op = img.getSampleModel().getNumBands() == 1 ? new BandCombineOp(ONE_BAND_MATRIX, null) : new BandCombineOp(THREE_BAND_MATRIX, null);
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        op.filter(img.getRaster(), bi.getRaster());
        return bi;
    }

    BufferedImage loadSymbolImage(String filename, char suffix, boolean queryIfNotFound) throws IOException {
        String fn = suffix == '\u0000' ? filename + "3.bmp" : filename + "-" + suffix + "3.bmp";
        File f = this.action.getCaseInsensitiveFile(new File(fn), null, queryIfNotFound, new BMPFileFilter());
        if (f == null && queryIfNotFound) {
            throw new FileNotFoundException("Missing bitmap file: " + fn);
        }
        if (f == null) {
            return null;
        }
        return ImageIO.read(f);
    }

    BufferedImage loadSymbolImage(String filename, char suffix) throws IOException {
        return this.loadSymbolImage(filename, suffix, true);
    }

    Dimension readDimension(DataInputStream in) throws IOException {
        Dimension d = null;
        for (int i = 0; i < 3; ++i) {
            int width = in.readInt();
            int height = in.readInt();
            if (2 != i) continue;
            d = new Dimension(width, height);
        }
        return d;
    }

    SymbolData getGamePiece(int index) {
        if (index >= 0 && index < this.gamePieceData.length) {
            return this.gamePieceData[index];
        }
        return null;
    }

    SymbolData getMapBoardSymbol(int index) {
        if (index >= 0 & index < this.mapBoardData.length) {
            return this.mapBoardData[index];
        }
        return null;
    }

    public Dimension getMaxSize(Dimension max) {
        if (max == null) {
            max = new Dimension(0, 0);
        }
        for (SymbolData piece : this.gamePieceData) {
            BufferedImage im = piece.getImage();
            if (im.getWidth() > max.width) {
                max.width = im.getWidth();
            }
            if (im.getHeight() <= max.height) continue;
            max.height = im.getHeight();
        }
        return max;
    }

    public Dimension getMaxSize() {
        return this.getMaxSize(null);
    }

    public Dimension getModalSize() {
        HashMap<Dimension, Integer> histogram = new HashMap<Dimension, Integer>();
        for (SymbolData piece : this.gamePieceData) {
            Dimension d;
            BufferedImage im = piece.getImage();
            Integer i = (Integer)histogram.get(d = new Dimension(im.getWidth(), im.getHeight()));
            histogram.put(d, i == null ? 1 : i + 1);
        }
        int max = 0;
        Dimension maxDim = new Dimension(0, 0);
        for (Map.Entry e : histogram.entrySet()) {
            Dimension d = (Dimension)e.getKey();
            int n = (Integer)e.getValue();
            if (n <= max) continue;
            max = n;
            maxDim.height = d.height;
            maxDim.width = d.width;
        }
        return maxDim;
    }

    int getMapBoardSymbolSize() {
        return this.mapBoardSymbolSize[2];
    }

    double getZoomFactor(int zoomLevel) {
        return (double)this.mapBoardSymbolSize[zoomLevel] / (double)this.mapBoardSymbolSize[2];
    }

    Shape getMapBoardSymbolShape() {
        return this.symbolShape;
    }

    void importCardSet(ImportAction a, File f) throws IOException {
        this.isCardSet = true;
        this.importFile(a, f);
    }

    @Override
    protected void load(File f) throws IOException {
        super.load(f);
        try (FileInputStream fin = new FileInputStream(f);
             BufferedInputStream bin = new BufferedInputStream(fin);
             DataInputStream in = new DataInputStream(bin);){
            this.header = in.readUnsignedByte();
            if (this.header < 250) {
                throw new FileFormatException("Invalid Symbol Set Header");
            }
            in.readByte();
            byte mapStyle = in.readByte();
            this.symbolShape = mapStyle == 1 ? Shape.HEX : Shape.SQUARE;
            byte symSetVersion = in.readByte();
            boolean bl = this.ignoreMask = symSetVersion != 0;
            if (this.isCardSet) {
                this.ignoreMask = true;
            }
            int nMapBoardSymbols = ADC2Utils.readBase250Word(in);
            this.mapBoardData = new SymbolData[nMapBoardSymbols];
            this.readDimension(in);
            int nGamePieceSymbols = ADC2Utils.readBase250Word(in);
            this.gamePieceData = new SymbolData[nGamePieceSymbols];
            this.readDimension(in);
            int nMasks = ADC2Utils.readBase250Word(in);
            this.readDimension(in);
            this.maskData = new SymbolData[nMasks];
            String baseName = SymbolSet.stripExtension(f.getPath());
            BufferedImage mapBoardImages = null;
            if (!this.isCardSet) {
                mapBoardImages = this.loadSymbolImage(baseName, 't');
            }
            for (int i = 0; i < nMapBoardSymbols; ++i) {
                this.mapBoardData[i] = new SymbolData(mapBoardImages, false).read(in);
                if (this.isCardSet) continue;
                if (this.mapBoardData[i].rect.height != this.mapBoardData[0].rect.height || this.mapBoardData[i].rect.width != this.mapBoardData[0].rect.width) {
                    throw new FileFormatException("Map board image dimensions are inconsistent");
                }
                if (this.mapBoardData[i].rect.width == this.mapBoardData[i].rect.height) continue;
                throw new FileFormatException("Map board image dimensions are not square");
            }
            BufferedImage gamePieceImages = this.isCardSet ? this.loadSymbolImage(baseName) : this.loadSymbolImage(baseName, 'u');
            for (int i = 0; i < nGamePieceSymbols; ++i) {
                this.gamePieceData[i] = new SymbolData(gamePieceImages, false).read(in);
            }
            if (!this.ignoreMask) {
                BufferedImage maskImages = this.loadSymbolImage(baseName, 'm');
                maskImages = SymbolSet.generateAlphaMask(maskImages);
                for (int i = 0; i < nMasks; ++i) {
                    this.maskData[i] = new SymbolData(maskImages, true).read(in);
                }
            }
            this.underlay = this.loadSymbolImage(baseName, 'z', false);
        }
        this.readPermutationFile(f);
    }

    private BufferedImage loadSymbolImage(String string) throws IOException {
        return this.loadSymbolImage(string, '\u0000');
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPermutationFile(File f) throws IOException {
        File sdx = new File(SymbolSet.forceExtension(f.getPath(), "sdx"));
        if ((sdx = this.action.getCaseInsensitiveFile(sdx, f, false, null)) == null) return;
        try (FileReader fr = new FileReader(sdx, StandardCharsets.US_ASCII);
             BufferedReader input = new BufferedReader(fr);){
            SymbolData[] pieces = Arrays.copyOf(this.gamePieceData, this.gamePieceData.length);
            String line = null;
            try {
                int i;
                for (i = 0; i < this.mapBoardData.length; ++i) {
                    line = input.readLine();
                }
                i = 0;
                while (i < pieces.length) {
                    line = input.readLine();
                    int idx = Integer.parseInt(line);
                    pieces[i] = this.gamePieceData[idx - 1];
                    ++i;
                }
                return;
            }
            catch (EOFException e) {
                log.debug("End of file reached", (Throwable)e);
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new FileFormatException("SDX file has out-of-bounds index \"" + line + "\".");
                catch (NumberFormatException e2) {
                    throw new FileFormatException("SDX file has invalid index \"" + line + "\".");
                }
            }
            finally {
                this.gamePieceData = pieces;
            }
        }
    }

    @Override
    public void writeToArchive() throws IOException {
        for (SymbolData piece : this.gamePieceData) {
            piece.writeToArchive();
        }
    }

    @Override
    public boolean isValidImportFile(File f) throws IOException {
        try (FileInputStream fin = new FileInputStream(f);){
            boolean bl;
            try (DataInputStream in = new DataInputStream(fin);){
                bl = in.readUnsignedByte() >= 250;
            }
            return bl;
        }
    }

    class SymbolData {
        private final BufferedImage bitmap;
        private String fileName;
        private BufferedImage img;
        private final boolean isMask;
        private int maskIndex;
        private String name;
        private Rectangle rect;
        private Boolean transparent;

        SymbolData(BufferedImage bitmap, boolean isMask) {
            this.bitmap = bitmap;
            this.isMask = isMask;
        }

        protected SymbolData getMask() {
            if (SymbolSet.this.ignoreMask || this.isMask) {
                return null;
            }
            if (this.maskIndex > 0 && this.maskIndex <= SymbolSet.this.maskData.length) {
                return SymbolSet.this.maskData[this.maskIndex - 1];
            }
            return null;
        }

        protected SymbolData read(DataInputStream in) throws IOException {
            this.name = Importer.readNullTerminatedString(in);
            boolean readAllZoomLevels = false;
            if (SymbolSet.this.mapBoardSymbolSize == null) {
                SymbolSet.this.mapBoardSymbolSize = new int[3];
                readAllZoomLevels = true;
            }
            this.maskIndex = SymbolSet.this.header == 253 ? in.readUnsignedByte() : ADC2Utils.readBase250Word(in);
            for (int i = 0; i < 3; ++i) {
                int x1 = in.readInt();
                int y1 = in.readInt();
                int x2 = in.readInt();
                int y2 = in.readInt();
                int width = x2 - x1 + 1;
                int height = y2 - y1 + 1;
                if (readAllZoomLevels) {
                    SymbolSet.this.mapBoardSymbolSize[i] = height;
                }
                if (i != 2) continue;
                this.rect = new Rectangle(x1, y1, width, height);
            }
            return this;
        }

        String getFileName() throws IOException {
            if (this.fileName == null) {
                this.writeToArchive();
            }
            return this.fileName;
        }

        boolean isTransparent() {
            if (this.transparent == null) {
                BufferedImage image = this.getImage();
                this.transparent = true;
                block0: for (int i = 0; i < image.getWidth(); ++i) {
                    for (int j = 0; j < image.getHeight(); ++j) {
                        if (image.getRGB(i, j) == 0) continue;
                        this.transparent = false;
                        break block0;
                    }
                }
            }
            return this.transparent;
        }

        private BufferedImage getImage(Rectangle rect2) {
            if (this.img == null) {
                if (this.isMask && (this.rect.width <= 0 || this.rect.height <= 0 || this.rect.width + this.rect.x > this.bitmap.getWidth() || this.rect.height + this.rect.y > this.bitmap.getHeight())) {
                    return new BufferedImage(rect2.width, rect2.height, 2);
                }
                this.img = this.bitmap.getSubimage(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                if (this.getMask() != null) {
                    BufferedImage bi = new BufferedImage(this.rect.width, this.rect.height, 2);
                    Graphics2D g = bi.createGraphics();
                    g.drawImage(this.img, null, 0, 0);
                    g.setComposite(AlphaComposite.DstAtop);
                    g.drawImage(this.getMask().getImage(this.rect), null, 0, 0);
                    this.img = bi;
                }
            }
            return this.img;
        }

        BufferedImage getImage() {
            return this.getImage(this.rect);
        }

        protected void writeToArchive() throws IOException {
            if (this.fileName == null) {
                this.fileName = Importer.getUniqueImageFileName(this.name);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.getImage(), "png", out);
                GameModule.getGameModule().getArchiveWriter().addImage(this.fileName, out.toByteArray());
            }
        }
    }

    static enum Shape {
        SQUARE,
        HEX;

    }
}

