/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.Symbol;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.configure.StringEnum;
import VASSAL.tools.SequenceEncoder;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import org.apache.commons.lang3.ArrayUtils;

public class SymbolItem
extends Item {
    public static final String TYPE = "Symbol";
    protected static final String SET = "set";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String LINE_WIDTH = "linewidth";
    protected String symbolSet = "";
    protected int height = 30;
    protected int width = 40;
    protected double lineWidth = 1.0;

    public SymbolItem() {
    }

    public SymbolItem(GamePieceLayout l) {
        super(l);
        this.width = this.getLayout().getLayoutWidth() / 2;
        this.height = (int)((double)this.width * 0.75);
    }

    public SymbolItem(GamePieceLayout l, String nam) {
        this(l);
        this.setConfigureName(nam);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeDescriptions(), (Object[])new String[]{"Symbol Set:  ", "Width:  ", "Height:  ", "Line Width:  "});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.insert((int)2, (Object[])super.getAttributeTypes(), (Object[])new Class[]{SetConfig.class, Integer.class, Integer.class, Double.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeNames(), (Object[])new String[]{SET, WIDTH, HEIGHT, LINE_WIDTH});
    }

    @Override
    public void setAttribute(String key, Object o) {
        switch (key) {
            case "width": {
                if (o instanceof String) {
                    o = Integer.valueOf((String)o);
                }
                this.width = (Integer)o;
                if (this.width >= 1) break;
                this.width = 1;
                break;
            }
            case "height": {
                if (o instanceof String) {
                    o = Integer.valueOf((String)o);
                }
                this.height = (Integer)o;
                if (this.height >= 1) break;
                this.height = 1;
                break;
            }
            case "linewidth": {
                if (o instanceof String) {
                    o = Double.valueOf((String)o);
                }
                this.lineWidth = (Double)o;
                if (!(this.lineWidth < 0.0)) break;
                this.lineWidth = 0.0;
                break;
            }
            default: {
                super.setAttribute(key, o);
            }
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SET.equals(key)) {
            return this.symbolSet;
        }
        if (WIDTH.equals(key)) {
            return String.valueOf(this.width);
        }
        if (HEIGHT.equals(key)) {
            return String.valueOf(this.height);
        }
        if (LINE_WIDTH.equals(key)) {
            return String.valueOf(this.lineWidth);
        }
        return super.getAttributeValueString(key);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(Graphics g, GamePieceImage defn) {
        SymbolItemInstance si = null;
        if (defn != null) {
            si = defn.getSymbolInstance(this.getConfigureName());
        }
        Symbol symbol = null;
        if (si == null) {
            symbol = new Symbol("NATO Unit Symbols", "Infantry", "None", "Division");
            si = new SymbolItemInstance();
        } else {
            symbol = new Symbol("NATO Unit Symbols", si.getSymbol1(), si.getSymbol2(), si.getSize());
        }
        Point origin = this.layout.getPosition(this);
        Rectangle r = new Rectangle(origin.x, origin.y, this.getWidth(), this.getHeight());
        if (this.getRotation() != 0) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform newXForm = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.layout.getPosition((Item)this).x, this.layout.getPosition((Item)this).y);
            g2d.transform(newXForm);
        }
        if (this.isAntialias()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        symbol.draw(g, r, si.getFgColor().getColor(), si.getBgColor().getColor(), si.getSizeColor().getColor(), (float)this.lineWidth);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout l, String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        SymbolItem item = new SymbolItem(l);
        sd.nextToken();
        item.width = sd.nextInt(54);
        item.height = sd.nextInt(54);
        item.lineWidth = sd.nextDouble(1.0);
        return item;
    }

    @Override
    public String encode() {
        SequenceEncoder se1 = new SequenceEncoder(TYPE, ';');
        se1.append(this.width);
        se1.append(this.height);
        se1.append(this.lineWidth);
        SequenceEncoder se2 = new SequenceEncoder(se1.getValue(), '|');
        se2.append(super.encode());
        return se2.getValue();
    }

    public static class SetConfig
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return Symbol.SYMBOL_SETS;
        }
    }
}

