/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.BasicPiece;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;

public class TurnGlobalHotkey
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    public static final String MATCH = "match";
    public static final String REPORT_FORMAT = "reportFormat";
    protected PropertyExpression match = new PropertyExpression();
    protected NamedKeyStroke hotkey;
    protected FormattedString format = new FormattedString();
    protected BasicPiece checkPiece = new BasicPiece();

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Description:  ", "Global Hotkey:  ", "Match Properties:  ", "Report Format:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, NamedKeyStroke.class, PropertyExpression.class, ReportFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, HOTKEY, MATCH, REPORT_FORMAT};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.hotkey);
        }
        if (MATCH.equals(key)) {
            return this.match.getExpression();
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.format.getFormat();
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.hotkey = (NamedKeyStroke)value;
        } else if (MATCH.equals(key)) {
            this.match.setExpression((String)value);
        } else if (REPORT_FORMAT.equals(key)) {
            this.format.setFormat((String)value);
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public void addTo(Buildable parent) {
    }

    public static String getConfigureTypeName() {
        return "Global Hotkey";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.htm", "Hotkey");
    }

    public void apply() {
        if (this.match.isNull() || this.match.accept(this.checkPiece)) {
            GameModule.getGameModule().fireKeyStroke(this.hotkey);
            String reportText = this.format.getLocalizedText();
            if (reportText.length() > 0) {
                Chatter.DisplayText c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + reportText);
                c.execute();
                GameModule.getGameModule().sendAndLog(c);
            }
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[0]);
        }
    }
}

