/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ui.RoomActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class JoinRoomAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Room r;
    private ChatServerConnection client;

    public JoinRoomAction(Room r, ChatServerConnection client) {
        super(Resources.getString("Chat.join_room"));
        this.r = r;
        this.client = client;
        this.setEnabled(r != null && !r.equals(client.getRoom()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.client.setRoom(this.r);
    }

    public static RoomActionFactory factory(final ChatServerConnection chatClient) {
        return new RoomActionFactory(){

            @Override
            public Action getAction(Room p, JTree tree) {
                return new JoinRoomAction(p, chatClient);
            }
        };
    }
}

