/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class BooleanConfigurer
extends Configurer {
    private JCheckBox box;

    public BooleanConfigurer(String key, String name, Boolean val) {
        super(key, name, val);
    }

    public BooleanConfigurer(String key, String name, boolean val) {
        super(key, name, val ? Boolean.TRUE : Boolean.FALSE);
    }

    public BooleanConfigurer(String key, String name) {
        this(key, name, Boolean.FALSE);
    }

    @Override
    public String getValueString() {
        return this.booleanValue().toString();
    }

    public boolean getValueBoolean() {
        return this.booleanValue();
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.box != null && !Boolean.valueOf(this.box.isSelected()).equals(o)) {
            this.box.setSelected(this.booleanValue());
        }
    }

    @Override
    public void setValue(String s) {
        this.setValue(Boolean.valueOf(s));
    }

    @Override
    public void setName(String s) {
        super.setName(s);
        if (this.box != null) {
            this.box.setText(s);
        }
    }

    @Override
    public Component getControls() {
        if (this.box == null) {
            this.box = new JCheckBox(this.getName());
            this.box.setSelected(this.booleanValue());
            this.box.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BooleanConfigurer.this.setValue(BooleanConfigurer.this.box.isSelected());
                }
            });
        }
        return this.box;
    }

    public Boolean booleanValue() {
        return (Boolean)this.value;
    }
}

