/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PlayerAccess;
import VASSAL.counters.SideAccess;
import VASSAL.counters.SpecifiedSideAccess;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PieceAccessConfigurer
extends Configurer {
    protected static String PLAYER = "player:";
    protected static String SIDE = "side:";
    protected static String SIDES = "sides:";
    protected JPanel controls;
    protected String[] prompts = new String[]{"Any player", "Any side", "Any of the specified sides"};
    protected JComboBox<String> selectType;
    protected StringArrayConfigurer sideConfig;

    public PieceAccessConfigurer(String key, String name, PieceAccess value) {
        super(key, name, value);
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        this.updateControls();
    }

    @Override
    public String getValueString() {
        return PieceAccessConfigurer.encode(this.getPieceAccess());
    }

    @Override
    public void setValue(String s) {
        this.setValue(PieceAccessConfigurer.decode(s));
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.getName()));
            this.selectType = new JComboBox<String>(this.getPrompts());
            this.selectType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PieceAccessConfigurer.this.updateValue();
                    PieceAccessConfigurer.this.sideConfig.getControls().setVisible(PieceAccessConfigurer.this.getValue() instanceof SpecifiedSideAccess);
                    if (PieceAccessConfigurer.this.controls.getTopLevelAncestor() instanceof Window) {
                        ((Window)PieceAccessConfigurer.this.controls.getTopLevelAncestor()).pack();
                    }
                }
            });
            box.add(this.selectType);
            this.controls.add(box);
            this.sideConfig = new StringArrayConfigurer(null, null);
            this.sideConfig.addPropertyChangeListener(evt -> this.updateValue());
            this.controls.add(this.sideConfig.getControls());
            this.updateControls();
        }
        return this.controls;
    }

    protected void updateValue() {
        this.noUpdate = true;
        if (this.prompts[1].equals(this.selectType.getSelectedItem())) {
            this.setValue(SideAccess.getInstance());
        } else if (this.prompts[2].equals(this.selectType.getSelectedItem())) {
            this.setValue(new SpecifiedSideAccess(Arrays.asList(this.sideConfig.getStringArray())));
        } else {
            this.setValue(PlayerAccess.getInstance());
        }
        this.noUpdate = false;
    }

    protected void updateControls() {
        if (!this.noUpdate && this.controls != null) {
            this.sideConfig.getControls().setVisible(this.getValue() instanceof SpecifiedSideAccess);
            if (this.getValue() instanceof SideAccess) {
                this.selectType.setSelectedIndex(1);
            } else if (this.getValue() instanceof SpecifiedSideAccess) {
                this.sideConfig.setValue(((SpecifiedSideAccess)this.getPieceAccess()).getSides().toArray(new String[0]));
                this.selectType.setSelectedIndex(2);
            } else {
                this.selectType.setSelectedIndex(0);
            }
        }
    }

    public String[] getPrompts() {
        return this.prompts;
    }

    public PieceAccess getPieceAccess() {
        return (PieceAccess)this.getValue();
    }

    public static PieceAccess decode(String s) {
        if (SIDE.equals(s)) {
            return SideAccess.getInstance();
        }
        if (s != null && s.startsWith(SIDES)) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s.substring(SIDES.length()), ':');
            ArrayList<String> l = new ArrayList<String>();
            while (sd.hasMoreTokens()) {
                l.add(sd.nextToken());
            }
            return new SpecifiedSideAccess(l);
        }
        return PlayerAccess.getInstance();
    }

    public static String encode(PieceAccess p) {
        String s = null;
        if (p instanceof SideAccess) {
            s = SIDE;
        } else if (p instanceof SpecifiedSideAccess) {
            SequenceEncoder se = new SequenceEncoder(':');
            for (String side : ((SpecifiedSideAccess)p).getSides()) {
                se.append(side);
            }
            s = se.getValue() == null ? SIDES : SIDES + se.getValue();
        } else if (p instanceof PlayerAccess) {
            s = PLAYER;
        }
        return s;
    }

    public void setPrompts(String[] prompts) {
        this.prompts = prompts;
        if (this.selectType != null) {
            this.selectType.setModel(new DefaultComboBoxModel<String>(prompts));
        }
    }
}

