/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class ShowHelpAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private HelpWindow helpWindow;
    private URL contents;

    public ShowHelpAction(URL contents, URL iconURL) {
        this((HelpWindow)null, contents, iconURL);
    }

    public ShowHelpAction(String key, URL contents, URL iconURL) {
        this(contents, iconURL);
        this.putValue("Name", Resources.getString(key));
    }

    public ShowHelpAction(HelpWindow helpWindow, HelpFile contents, URL iconURL) {
        this(helpWindow, contents == null ? null : contents.getContents(), iconURL);
        this.setEnabled(contents != null);
    }

    public ShowHelpAction(HelpWindow helpWindow, URL contents, URL iconURL) {
        this.helpWindow = helpWindow;
        this.contents = contents;
        if (iconURL != null) {
            this.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        this.putValue("Name", Resources.getString("General.help"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.contents != null) {
            if (this.helpWindow == null) {
                BrowserSupport.openURL(this.contents.toString());
            } else {
                this.helpWindow.update(this.contents);
                this.helpWindow.setVisible(true);
            }
        }
    }
}

