/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure.password;

import VASSAL.i18n.Resources;
import VASSAL.tools.icon.IconFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class ToggleablePasswordFieldPanel {
    private static final char ECHO_CHAR = '\u2022';
    private final JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[][]"));
    private final JPasswordField passwordField;
    private boolean passwordVisible = false;

    public ToggleablePasswordFieldPanel(String label, String initialPassword) {
        JLabel passwordLabel = new JLabel(label);
        this.panel.add(passwordLabel);
        this.passwordField = new JPasswordField(12);
        this.passwordField.setEchoChar('\u2022');
        this.passwordField.setText(initialPassword);
        passwordLabel.setLabelFor(this.passwordField);
        this.panel.add((Component)this.passwordField, "pushx, growx, sizegroupy foo");
        Icon eye = IconFactory.getIcon("eye", 0);
        Icon noEye = IconFactory.getIcon("eye-slash", 0);
        JButton toggleButton = new JButton(noEye);
        toggleButton.setToolTipText(Resources.getString("GlobalOptions.toggle_password_visibility"));
        toggleButton.addActionListener(e -> {
            this.passwordVisible = !this.passwordVisible;
            this.passwordField.setEchoChar(this.passwordVisible ? (char)'\u0000' : (char)'\u2022');
            toggleButton.setIcon(this.passwordVisible ? eye : noEye);
        });
        this.panel.add((Component)toggleButton, "sizegroupy foo");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getPassword() {
        return String.valueOf(this.passwordField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordField.setText(password);
    }

    public void addPasswordFieldListener(DocumentListener documentListener) {
        this.passwordField.getDocument().addDocumentListener(documentListener);
    }
}

