/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;

public class DynamicProperty
extends Decorator
implements TranslatablePiece,
PropertyPrompt.DialogParent,
PropertyChangerConfigurer.Constraints {
    public static final String ID = "PROP;";
    protected String value;
    protected String key;
    protected boolean numeric;
    protected int minValue;
    protected int maxValue;
    protected boolean wrap;
    protected FormattedString format = new FormattedString();
    protected DynamicKeyCommand[] keyCommands;
    protected KeyCommand[] menuCommands;
    protected ListConfigurer keyCommandListConfig;

    public DynamicProperty() {
        this(ID, null);
    }

    public DynamicProperty(String type, GamePiece p) {
        this.setInner(p);
        this.keyCommandListConfig = new ListConfigurer(null, "Commands"){

            @Override
            protected Configurer buildChildConfigurer() {
                return new DynamicKeyCommandConfigurer(DynamicProperty.this);
            }
        };
        this.mySetType(type);
    }

    @Override
    public void mySetType(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        this.key = sd.nextToken("name");
        this.decodeConstraints(sd.nextToken(""));
        this.keyCommandListConfig.setValue(sd.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicKeyCommand[0]);
        this.menuCommands = (KeyCommand[])Arrays.stream(this.keyCommands).filter(kc -> !StringUtils.isEmpty((CharSequence)kc.getName())).toArray(KeyCommand[]::new);
    }

    protected void decodeConstraints(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        this.numeric = sd.nextBoolean(false);
        this.minValue = sd.nextInt(0);
        this.maxValue = sd.nextInt(100);
        this.wrap = sd.nextBoolean(false);
    }

    protected String encodeConstraints() {
        return new SequenceEncoder(',').append(this.numeric).append(this.minValue).append(this.maxValue).append(this.wrap).getValue();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.getKey())) {
            return this.getValue();
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.getKey())) {
            return this.getValue();
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (key.equals(this.getKey())) {
            this.setValue(null == value ? null : value.toString());
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public String myGetState() {
        return this.getValue();
    }

    @Override
    public Component getComponent() {
        return this.getMap() != null ? this.getMap().getView().getTopLevelAncestor() : GameModule.getGameModule().getPlayerWindow();
    }

    @Override
    public void mySetState(String state) {
        this.setValue(state);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        Stack parent = this.getParent();
        Map map = this.getMap();
        value = this.formatValue(value);
        if (map != null && !(this.getParent() instanceof Deck)) {
            GamePiece outer = Decorator.getOutermost(this);
            if (parent == null) {
                Point pos = this.getPosition();
                map.removePiece(outer);
                this.value = value;
                map.placeOrMerge(outer, pos);
            } else {
                GamePiece other = parent.getPieceBeneath(outer);
                if (other == null) {
                    other = parent.getPieceAbove(outer);
                }
                if (other == null) {
                    Point pos = parent.getPosition();
                    map.removePiece(parent);
                    this.value = value;
                    map.placeOrMerge(parent, pos);
                } else {
                    this.value = value;
                    if (!map.getPieceCollection().canMerge(other, outer)) {
                        map.placeOrMerge(outer, parent.getPosition());
                    }
                }
            }
        } else {
            this.value = value;
        }
    }

    private String formatValue(String value) {
        this.format.setFormat(value);
        return this.format.getText(Decorator.getOutermost(this));
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.key);
        se.append(this.encodeConstraints());
        se.append(this.keyCommandListConfig.getValueString());
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return this.menuCommands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        ChangeTracker tracker = new ChangeTracker(this);
        for (DynamicKeyCommand dkc : this.keyCommands) {
            if (!dkc.matches(stroke)) continue;
            this.setValue(dkc.propChanger.getNewValue(this.value));
        }
        return tracker.getChangeCommand();
    }

    @Override
    public String getDescription() {
        Object s = "Dynamic Property";
        if (this.getKey() != null && this.getKey().length() > 0) {
            s = (String)s + " - " + this.getKey();
        }
        return s;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("DynamicProperty.htm");
    }

    @Override
    public int getMaximumValue() {
        return this.maxValue;
    }

    @Override
    public int getMinimumValue() {
        return this.minValue;
    }

    @Override
    public boolean isNumeric() {
        return this.numeric;
    }

    @Override
    public boolean isWrap() {
        return this.wrap;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.key);
        return l;
    }

    @Override
    public PropertySource getPropertySource() {
        return Decorator.getOutermost(this);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        String[] commandNames = new String[this.menuCommands.length];
        String[] commandDescs = new String[this.menuCommands.length];
        for (int i = 0; i < this.menuCommands.length; ++i) {
            commandNames[i] = this.menuCommands[i].getName();
            commandDescs[i] = "Property " + this.key + ": Menu Command " + i;
        }
        return this.getI18nData(commandNames, commandDescs);
    }

    protected static class DynamicKeyCommand
    extends KeyCommand {
        private static final long serialVersionUID = 1L;
        protected PropertyChanger propChanger;

        public DynamicKeyCommand(String name, NamedKeyStroke key, GamePiece target, TranslatablePiece i18nPiece, PropertyChanger propChanger) {
            super(name, key, target, i18nPiece);
            this.propChanger = propChanger;
        }
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer nameConfig;
        protected StringConfigurer initialValueConfig;
        protected BooleanConfigurer numericConfig;
        protected IntConfigurer minConfig;
        protected IntConfigurer maxConfig;
        protected BooleanConfigurer wrapConfig;
        protected ListConfigurer keyCommandListConfig;
        protected Box controls;

        public Ed(final DynamicProperty m) {
            this.keyCommandListConfig = new ListConfigurer(null, "Key Commands"){

                @Override
                protected Configurer buildChildConfigurer() {
                    return new DynamicKeyCommandConfigurer(m);
                }
            };
            this.keyCommandListConfig.setValue(new ArrayList<DynamicKeyCommand>(Arrays.asList(m.keyCommands)));
            PropertyChangeListener l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isNumeric = numericConfig.booleanValue();
                    minConfig.getControls().setVisible(isNumeric);
                    maxConfig.getControls().setVisible(isNumeric);
                    wrapConfig.getControls().setVisible(isNumeric);
                    keyCommandListConfig.repack();
                }
            };
            this.controls = Box.createVerticalBox();
            this.nameConfig = new StringConfigurer(null, "Name:  ", m.getKey());
            this.controls.add(this.nameConfig.getControls());
            this.initialValueConfig = new StringConfigurer(null, "Value:  ", m.getValue());
            this.controls.add(this.initialValueConfig.getControls());
            this.numericConfig = new BooleanConfigurer(null, "Is numeric:  ", m.isNumeric());
            this.controls.add(this.numericConfig.getControls());
            this.minConfig = new IntConfigurer(null, "Minimum value:  ", (Integer)m.getMinimumValue());
            this.controls.add(this.minConfig.getControls());
            this.maxConfig = new IntConfigurer(null, "Maximum value:  ", (Integer)m.getMaximumValue());
            this.controls.add(this.maxConfig.getControls());
            this.wrapConfig = new BooleanConfigurer(null, "Wrap?", m.isWrap());
            this.controls.add(this.wrapConfig.getControls());
            this.controls.add(this.keyCommandListConfig.getControls());
            this.numericConfig.addPropertyChangeListener(l);
            this.numericConfig.fireUpdate();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString());
            se.append(this.encodeConstraints());
            se.append(this.keyCommandListConfig.getValueString());
            return DynamicProperty.ID + se.getValue();
        }

        @Override
        public String getState() {
            return this.initialValueConfig.getValueString();
        }
    }

    protected static class DynamicKeyCommandConfigurer
    extends Configurer {
        protected final NamedHotKeyConfigurer keyConfig;
        protected PropertyChangerConfigurer propChangeConfig;
        protected StringConfigurer commandConfig = new StringConfigurer(null, " Menu Command:  ", "Change value");
        protected Box controls = null;
        protected DynamicProperty target;

        public DynamicKeyCommandConfigurer(DynamicProperty target) {
            super(target.getKey(), target.getKey(), new DynamicKeyCommand("Change value", NamedKeyStroke.getNamedKeyStroke('V', 128), Decorator.getOutermost(target), target, new PropertyPrompt(target, "Change value of " + target.getKey())));
            this.keyConfig = new NamedHotKeyConfigurer(null, " Key Command:  ", NamedKeyStroke.getNamedKeyStroke('V', 128));
            this.propChangeConfig = new PropertyChangerConfigurer(null, target.getKey(), target);
            this.propChangeConfig.setValue(new PropertyPrompt(target, " Change value of " + target.getKey()));
            PropertyChangeListener pl = e -> this.updateValue();
            this.commandConfig.addPropertyChangeListener(pl);
            this.keyConfig.addPropertyChangeListener(pl);
            this.propChangeConfig.addPropertyChangeListener(pl);
            this.target = target;
        }

        @Override
        public String getValueString() {
            SequenceEncoder se = new SequenceEncoder(':');
            se.append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.propChangeConfig.getValueString());
            return se.getValue();
        }

        @Override
        public void setValue(Object value) {
            if (!this.noUpdate && value instanceof DynamicKeyCommand && this.commandConfig != null) {
                DynamicKeyCommand dkc = (DynamicKeyCommand)value;
                this.commandConfig.setValue(dkc.getName());
                this.keyConfig.setValue(dkc.getNamedKeyStroke());
                this.propChangeConfig.setValue(dkc.propChanger);
            }
            super.setValue(value);
        }

        public DynamicKeyCommand getKeyCommand() {
            return (DynamicKeyCommand)this.getValue();
        }

        @Override
        public void setValue(String s) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s == null ? "" : s, ':');
            this.commandConfig.setValue(sd.nextToken(""));
            this.keyConfig.setValue(sd.nextNamedKeyStroke(null));
            this.propChangeConfig.setValue(sd.nextToken(""));
            this.updateValue();
        }

        @Override
        public Component getControls() {
            if (this.controls == null) {
                this.buildControls();
            }
            return this.controls;
        }

        protected void updateValue() {
            this.noUpdate = true;
            this.setValue(new DynamicKeyCommand(this.commandConfig.getValueString(), this.keyConfig.getValueNamedKeyStroke(), this.target, this.target, this.propChangeConfig.getPropertyChanger()));
            this.noUpdate = false;
        }

        protected void buildControls() {
            this.controls = Box.createHorizontalBox();
            this.controls.add(this.commandConfig.getControls());
            this.controls.add(this.keyConfig.getControls());
            this.controls.add(this.propChangeConfig.getControls());
        }
    }
}

