/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.PlayerRoster;
import VASSAL.counters.PieceAccess;
import java.util.Collections;
import java.util.List;

public class SpecifiedSideAccess
implements PieceAccess {
    private List<String> sides;

    public SpecifiedSideAccess(List<String> sides) {
        this.sides = Collections.unmodifiableList(sides);
    }

    @Override
    public String getCurrentPlayerId() {
        return PlayerRoster.getMySide();
    }

    @Override
    public boolean currentPlayerHasAccess(String ownerId) {
        if (ownerId == null) {
            return true;
        }
        if (this.sides.contains(ownerId)) {
            return !PieceAccess.GlobalAccess.isHideAll() && this.sides.contains(this.getCurrentPlayerId());
        }
        return false;
    }

    public List<String> getSides() {
        return this.sides;
    }

    @Override
    public boolean currentPlayerCanModify(String ownerId) {
        return this.sides.contains(this.getCurrentPlayerId());
    }
}

