/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.configure.ExtensionTree;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.menu.MenuManager;
import java.io.IOException;
import javax.swing.JDialog;

public class ExtensionEditorWindow
extends EditorWindow {
    private static final long serialVersionUID = 1L;
    protected static ExtensionEditorWindow instance = null;
    protected ModuleExtension extension;

    public ExtensionEditorWindow(GameModule mod, ModuleExtension ext) {
        this.extension = ext;
        this.tree = new ExtensionTree(mod, this.helpWindow, ext, this);
        this.treeStateChanged(false);
        this.scrollPane.setViewportView(this.tree);
        this.tree.populateEditMenu(this);
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("Editor.ModuleEditor.reference_manual", this.tree.getHelpAction());
        this.toolBar.addSeparator();
        this.toolBar.add(this.extension.getEditAction(new JDialog(this)));
        this.saveAction.setEnabled(true);
        this.saveAsAction.setEnabled(true);
        this.createUpdater.setEnabled(true);
        this.pack();
    }

    public void moduleLoading(GameModule mod) {
    }

    @Override
    public String getEditorType() {
        return "Extension";
    }

    @Override
    protected void save() {
        this.saver(new Runnable(){

            @Override
            public void run() {
                try {
                    ExtensionEditorWindow.this.extension.save();
                }
                catch (IOException e) {
                    WriteErrorDialog.error(e, ExtensionEditorWindow.this.extension.getDataArchive().getName());
                }
            }
        });
    }

    @Override
    protected void saveAs() {
        this.saver(new Runnable(){

            @Override
            public void run() {
                try {
                    ExtensionEditorWindow.this.extension.saveAs();
                }
                catch (IOException e) {
                    WriteErrorDialog.error(e, ExtensionEditorWindow.this.extension.getDataArchive().getName());
                }
            }
        });
    }
}

