/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.SavedGameUpdaterDialog;
import VASSAL.i18n.Resources;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ModuleEditorWindow
extends EditorWindow {
    private static final long serialVersionUID = 1L;
    protected Action updateSavedGame;

    public ModuleEditorWindow(GameModule mod) {
        this.tree = new ConfigureTree(mod, this.helpWindow, this);
        this.treeStateChanged(false);
        this.scrollPane.setViewportView(this.tree);
        MenuManager mm = MenuManager.getInstance();
        this.tree.populateEditMenu(this);
        mm.addAction("Editor.ModuleEditor.reference_manual", this.tree.getHelpAction());
        this.updateSavedGame = new AbstractAction(Resources.getString("Editor.ModuleEditor.update_saved")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new SavedGameUpdaterDialog(ModuleEditorWindow.this).setVisible(true);
            }
        };
        mm.addAction("Editor.ModuleEditor.update_saved", this.updateSavedGame);
        this.saveAction.setEnabled(true);
        this.saveAsAction.setEnabled(true);
        this.createUpdater.setEnabled(true);
        this.updateSavedGame.setEnabled(true);
        this.pack();
    }

    @Override
    public String getEditorType() {
        return "Module";
    }

    @Override
    protected void save() {
        this.saver(new Runnable(){

            @Override
            public void run() {
                GameModule.getGameModule().save();
            }
        });
    }

    @Override
    protected void saveAs() {
        this.saver(new Runnable(){

            @Override
            public void run() {
                GameModule.getGameModule().saveAs();
            }
        });
    }
}

