/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.AbstractOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTileOpImpl
extends AbstractOpImpl {
    @Override
    public Dimension getTileSize() {
        return this.getSize();
    }

    @Override
    public int getTileHeight() {
        return this.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.getWidth();
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public BufferedImage getTile(int tileX, int tileY, ImageOpObserver obs) throws CancellationException, InterruptedException, ExecutionException {
        if (tileX != 0 || tileY != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getImage(obs);
    }

    @Override
    public Future<BufferedImage> getFutureTile(int tileX, int tileY, ImageOpObserver obs) throws ExecutionException {
        if (tileX != 0 || tileY != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getFutureImage(obs);
    }

    @Override
    public ImageOp getTileOp(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public Point[] getTileIndices(Rectangle rect) {
        Point[] pointArray;
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        if (rect.intersects(new Rectangle(this.size))) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = new Point(0, 0);
        } else {
            pointArray = new Point[]{};
        }
        return pointArray;
    }
}

