/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.Info;
import VASSAL.tools.concurrent.CountingReadWriteLock;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class ZipArchive
implements FileArchive {
    private final File archiveFile;
    private ZipFile zipFile;
    private boolean modified = false;
    private boolean closed = true;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final ReadWriteLock rwl = new CountingReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public ZipArchive(String path) throws IOException {
        this(path, false);
    }

    public ZipArchive(File file) throws IOException {
        this(file, false);
    }

    public ZipArchive(String path, boolean truncate) throws IOException {
        this(new File(path), truncate);
    }

    public ZipArchive(File file, boolean truncate) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.archiveFile = file;
        if (truncate) {
            this.archiveFile.delete();
        }
    }

    public ZipArchive(FileArchive src, String dst) throws IOException {
        this(src, new File(dst));
    }

    public ZipArchive(FileArchive src, File dst) throws IOException {
        this(dst, true);
        byte[] buf = new byte[8192];
        for (String name : src.getFiles()) {
            InputStream in = src.getInputStream(name);
            try {
                OutputStream out = this.getOutputStream(name);
                try {
                    IOUtils.copy(in, out, buf);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        this.flush();
    }

    @Override
    public String getName() {
        return this.archiveFile.getPath();
    }

    @Override
    public File getFile() {
        return this.archiveFile;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            InputStream in = null;
            if (e.file != null) {
                in = new FileInputStream(e.file);
            } else if (this.zipFile != null) {
                in = this.zipFile.getInputStream(e.ze);
            }
            if (in == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            return new ZipArchiveInputStream(in);
        }
        catch (IOException ex) {
            this.r.unlock();
            throw ex;
        }
    }

    @Override
    public OutputStream getOutputStream(String path) throws IOException {
        return this.getOutputStream(path, true);
    }

    public OutputStream getOutputStream(String path, boolean compress) throws IOException {
        this.w.lock();
        try {
            this.openIfClosed();
            this.modified = true;
            ZipEntry ze = new ZipEntry(path);
            ze.setMethod(compress ? 8 : 0);
            File tf = this.makeTempFileFor(path);
            Entry e = new Entry(ze, tf);
            Entry old = this.entries.put(path, e);
            if (old != null && old.file != null) {
                old.file.delete();
            }
            return new ZipArchiveOutputStream(new FileOutputStream(e.file), new CRC32(), e.ze);
        }
        catch (IOException ex) {
            this.w.unlock();
            throw ex;
        }
    }

    @Override
    public void add(String path, String extPath) throws IOException {
        this.add(path, new File(extPath));
    }

    @Override
    public void add(String path, File extPath) throws IOException {
        try (FileInputStream in = new FileInputStream(extPath);){
            this.add(path, in);
        }
    }

    @Override
    public void add(String path, byte[] bytes) throws IOException {
        this.add(path, new ByteArrayInputStream(bytes));
    }

    @Override
    public void add(String path, InputStream in) throws IOException {
        try (OutputStream out = this.getOutputStream(path);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String path) throws IOException {
        this.w.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.remove(path);
            if (e != null) {
                this.modified = true;
                if (e.file != null) {
                    e.file.delete();
                }
            }
            boolean bl = e != null;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void revert() throws IOException {
        this.w.lock();
        try {
            if (!this.modified) {
                return;
            }
            for (Entry e : this.entries.values()) {
                if (e == null || e.file == null) continue;
                e.file.delete();
            }
            this.modified = false;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.w.lock();
        try {
            if (this.modified) {
                this.writeToDisk();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.w.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.modified) {
                this.writeToDisk();
            } else if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
                this.closed = true;
                this.entries.clear();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private String extensionOf(String path) {
        int dot = path.lastIndexOf(46);
        return dot == -1 ? "" : path.substring(dot);
    }

    private File makeTempFileFor(String path) throws IOException {
        String base = FilenameUtils.getBaseName((String)path) + "_";
        String ext = this.extensionOf(path);
        return Files.createTempFile(Info.getTempDir().toPath(), base, ext, new FileAttribute[0]).toFile();
    }

    private void moveFile(Path src, Path dst) throws IOException {
        try {
            Files.move(src, dst, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ignore) {
            try {
                Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                String fmt = "Unable to overwrite %s, so data written to %s instead: %s";
                throw new IOException(String.format("Unable to overwrite %s, so data written to %s instead: %s", dst.toAbsolutePath(), src.toAbsolutePath(), e.getMessage()), e);
            }
            try {
                Files.delete(src);
            }
            catch (IOException e) {
                String fmt = "File %s saved, but unable to remove temporary file %s: %s";
                throw new IOException(String.format("File %s saved, but unable to remove temporary file %s: %s", dst.toAbsolutePath(), src.toAbsolutePath(), e.getMessage()), e);
            }
        }
    }

    private void writeToDisk() throws IOException {
        File tmpFile = this.makeTempFileFor(this.archiveFile.getName());
        try (FileOutputStream fout = new FileOutputStream(tmpFile);
             BufferedOutputStream bout = new BufferedOutputStream(fout);
             ZipOutputStream out = new ZipOutputStream(bout);){
            InputStream in;
            out.setLevel(9);
            byte[] buf = new byte[8192];
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
                try (FileInputStream fin = new FileInputStream(this.archiveFile);
                     BufferedInputStream bin = new BufferedInputStream(fin);){
                    in = new ZipInputStream(bin);
                    try {
                        ZipEntry ze = null;
                        while ((ze = ((ZipInputStream)in).getNextEntry()) != null) {
                            Entry e = this.entries.get(ze.getName());
                            if (e == null || e.file != null) continue;
                            if (ze.getMethod() == 8) {
                                ZipEntry nze = new ZipEntry(ze.getName());
                                nze.setTime(ze.getTime());
                                ze = nze;
                            }
                            out.putNextEntry(ze);
                            IOUtils.copy(in, out, buf);
                            this.entries.remove(ze.getName());
                        }
                    }
                    finally {
                        ((ZipInputStream)in).close();
                    }
                }
            }
            for (Entry e : this.entries.values()) {
                if (e == null || e.file == null) continue;
                in = new FileInputStream(e.file);
                try {
                    e.ze.setTime(e.file.lastModified());
                    out.putNextEntry(e.ze);
                    IOUtils.copy(in, out, buf);
                }
                finally {
                    ((FileInputStream)in).close();
                }
            }
        }
        this.moveFile(tmpFile.toPath(), this.archiveFile.toPath());
        for (Entry e : this.entries.values()) {
            if (e == null || e.file == null) continue;
            e.file.delete();
        }
        this.closed = true;
        this.modified = false;
        this.entries.clear();
    }

    @Override
    public boolean contains(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            boolean bl = this.entries.containsKey(path);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            long l = e.file == null ? e.ze.getSize() : e.file.length();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMTime(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            long l = e.file == null ? e.ze.getTime() : e.file.lastModified();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public List<String> getFiles() throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            ArrayList<String> arrayList = new ArrayList<String>(this.entries.keySet());
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFiles(String root) throws IOException {
        if (((String)root).length() == 0) {
            return this.getFiles();
        }
        this.r.lock();
        try {
            this.openIfClosed();
            root = (String)root + "/";
            ArrayList<String> names = new ArrayList<String>();
            for (String n : this.entries.keySet()) {
                if (!n.startsWith((String)root)) continue;
                names.add(n);
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    private synchronized void readEntries() throws IOException {
        this.entries.clear();
        if (this.archiveFile.exists() && this.archiveFile.length() > 0L) {
            this.zipFile = new ZipFile(this.archiveFile);
            this.zipFile.stream().forEach(e -> this.entries.put(e.getName(), new Entry((ZipEntry)e, null)));
        }
    }

    private synchronized void openIfClosed() throws IOException {
        if (this.closed) {
            this.readEntries();
            this.modified = false;
            this.closed = false;
        }
    }

    public static void main(String[] args) throws IOException {
        ZipArchive archive = new ZipArchive("test.zip");
        archive.add("NOTES", "NOTES");
        archive.add("README.txt", "README.txt");
        archive.flush();
        try (InputStream in = archive.getInputStream("NOTES");){
            IOUtils.copy((InputStream)in, (OutputStream)System.out);
        }
        archive.close();
    }

    private static class Entry {
        public ZipEntry ze;
        public File file;

        public Entry(ZipEntry ze, File file) {
            this.ze = ze;
            this.file = file;
        }

        public String toString() {
            return this.getClass().getName() + "[file=\"" + this.file + "\", ze=\"" + this.ze + "\"]";
        }
    }

    private class ZipArchiveInputStream
    extends FilterInputStream {
        private boolean closed;

        public ZipArchiveInputStream(InputStream in) {
            super(in);
            this.closed = false;
            if (in == null) {
                throw new NullPointerException("in == null");
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ZipArchive.this.r.unlock();
                this.closed = true;
            }
        }
    }

    private class ZipArchiveOutputStream
    extends CheckedOutputStream {
        private ZipEntry entry;
        private long count;
        private boolean closed;

        public ZipArchiveOutputStream(OutputStream out, Checksum cksum, ZipEntry e) {
            super(out, cksum);
            this.count = 0L;
            this.closed = false;
            if (out == null) {
                throw new NullPointerException("out == null");
            }
            if (cksum == null) {
                throw new NullPointerException("cksum == null");
            }
            if (e == null) {
                throw new NullPointerException("e == null");
            }
            this.entry = e;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            super.write(bytes, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.count;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.entry.setSize(this.count);
            this.entry.setCrc(this.getChecksum().getValue());
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ZipArchive.this.w.unlock();
                this.closed = true;
            }
        }
    }
}

