/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameRefresher
implements GameComponent {
    private static final Logger logger = LoggerFactory.getLogger(GameRefresher.class);
    private Action refreshAction;
    protected GpIdSupport gpIdSupport;
    protected GpIdChecker gpIdChecker;
    protected int updatedCount;
    protected int notFoundCount;
    protected int notOwnedCount;
    protected RefreshDialog dialog;
    protected boolean testMode;

    public GameRefresher(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
    }

    public void addTo(AbstractConfigurable parent) {
        this.refreshAction = new AbstractAction(Resources.getString("GameRefresher.refresh_counters")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new GameRefresher(GameRefresher.this.gpIdSupport).start();
            }
        };
        this.refreshAction.setEnabled(false);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void start() {
        this.dialog = new RefreshDialog(this);
        this.dialog.setVisible(true);
        this.dialog = null;
    }

    public void execute(boolean testMode, boolean useName) {
        this.testMode = testMode;
        GameModule theModule = GameModule.getGameModule();
        this.updatedCount = 0;
        this.notFoundCount = 0;
        this.notOwnedCount = 0;
        this.gpIdChecker = new GpIdChecker(useName);
        for (PieceSlot slot : theModule.getAllDescendantComponentsOf(PieceSlot.class)) {
            this.gpIdChecker.add(slot);
        }
        for (PrototypesContainer pc : theModule.getComponentsOf(PrototypesContainer.class)) {
            pc.getDefinitions().forEach(this.gpIdChecker::add);
        }
        if (this.gpIdChecker.hasErrors()) {
            ErrorDialog.show("GameRefresher.no_gpids", new Object[0]);
            this.gpIdChecker = null;
            return;
        }
        NullCommand command = new NullCommand();
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        for (GamePiece piece : theModule.getGameState().getAllPieces()) {
            Iterator<GamePiece> i;
            if (piece instanceof Deck) {
                i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    pieces.add(0, i.next());
                }
                continue;
            }
            if (piece instanceof Stack) {
                i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    GamePiece p = i.next();
                    if (!Boolean.TRUE.equals(p.getProperty("Invisible")) && !Boolean.TRUE.equals(p.getProperty("Obscured"))) {
                        pieces.add(0, p);
                        continue;
                    }
                    ++this.notOwnedCount;
                }
                continue;
            }
            if (piece.getParent() != null) continue;
            if (!Boolean.TRUE.equals(piece.getProperty("Invisible")) && !Boolean.TRUE.equals(piece.getProperty("Obscured"))) {
                pieces.add(0, piece);
                continue;
            }
            ++this.notOwnedCount;
        }
        for (GamePiece piece : pieces) {
            if (this.isTestMode()) {
                this.testGamePiece(piece);
                continue;
            }
            this.processGamePiece(piece, command);
        }
        if (this.isTestMode()) {
            if (this.dialog != null) {
                this.dialog.addMessage(Resources.getString("GameRefresher.counters_refreshed_test", this.updatedCount));
                if (this.notOwnedCount > 0) {
                    this.dialog.addMessage(Resources.getString("GameRefresher.counters_not_owned_test", this.notOwnedCount));
                }
                if (this.notFoundCount > 0) {
                    this.dialog.addMessage(Resources.getString("GameRefresher.counters_not_found_test", this.notFoundCount));
                }
            }
        } else {
            String player = GlobalOptions.getInstance().getPlayerId();
            Chatter chatter = theModule.getChatter();
            Chatter.DisplayText msg = new Chatter.DisplayText(chatter, "----------");
            msg.append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.run_refresh_counters", player)));
            msg.append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.counters_refreshed", player, this.updatedCount)));
            if (this.notOwnedCount > 0) {
                msg.append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.counters_not_owned", player, this.notOwnedCount)));
            }
            if (this.notFoundCount > 0) {
                msg.append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.counters_not_found", player, this.notFoundCount)));
            }
            msg.append(new Chatter.DisplayText(chatter, "----------"));
            msg.execute();
            command.append(msg);
            theModule.sendAndLog(command);
        }
        this.gpIdChecker = null;
    }

    private void processGamePiece(GamePiece piece, Command command) {
        int newPos;
        Stack newStack;
        int oldPos;
        Map map = piece.getMap();
        if (map == null) {
            logger.error("Can't refresh piece " + piece.getName() + ": No Map");
            return;
        }
        Point pos = piece.getPosition();
        GamePiece newPiece = this.gpIdChecker.createUpdatedPiece(piece);
        Stack oldStack = piece.getParent();
        int n = oldPos = oldStack == null ? 0 : oldStack.indexOf(piece);
        if (piece.equals(newPiece)) {
            ++this.notFoundCount;
            logger.error("Can't refresh piece " + piece.getName() + ": Can't find matching Piece Slot");
        } else {
            ++this.updatedCount;
            if (!this.isTestMode()) {
                Command place = map.placeOrMerge(newPiece, pos);
                command.append(place);
                RemovePiece remove = new RemovePiece(Decorator.getOutermost(piece));
                remove.execute();
                command.append(remove);
            }
        }
        if (!this.isTestMode() && (newStack = newPiece.getParent()) != null && newStack == oldStack && (newPos = newStack.indexOf(newPiece)) >= 0 && oldPos >= 0 && newPos != oldPos) {
            String oldState = newStack.getState();
            newStack.insert(newPiece, oldPos);
            command.append(new ChangePiece(newStack.getId(), oldState, newStack.getState()));
        }
    }

    private void testGamePiece(GamePiece piece) {
        Map map = piece.getMap();
        if (map == null) {
            logger.error("Can't refresh piece " + piece.getName() + ": No Map");
            return;
        }
        if (this.gpIdChecker.findUpdatedPiece(piece)) {
            ++this.updatedCount;
        } else {
            ++this.notFoundCount;
            logger.error("Can't refresh piece " + piece.getName() + ": Can't find matching Piece Slot");
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        this.refreshAction.setEnabled(gameStarting);
    }

    static class RefreshDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final GameRefresher refresher;
        private JTextArea results;
        private JCheckBox nameCheck;

        RefreshDialog(GameRefresher refresher) {
            this.refresher = refresher;
            this.setTitle(Resources.getString("GameRefresher.refresh_counters"));
            this.setModal(true);
            this.initComponents();
        }

        protected void initComponents() {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    this.exit();
                }
            });
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "[center]"));
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
            JButton testButton = new JButton(Resources.getString("General.test"));
            testButton.addActionListener(e -> this.test());
            JButton runButton = new JButton(Resources.getString("General.run"));
            runButton.addActionListener(e -> this.run());
            JButton exitButton = new JButton(Resources.getString("General.exit"));
            exitButton.addActionListener(e -> this.exit());
            buttonPanel.add(testButton);
            buttonPanel.add(runButton);
            buttonPanel.add(exitButton);
            this.add(buttonPanel);
            this.results = new JTextArea(7, 40);
            this.results.setEditable(false);
            this.add(this.results);
            this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
            this.add(this.nameCheck);
            this.pack();
        }

        protected void exit() {
            this.setVisible(false);
        }

        protected void test() {
            this.results.setText(Resources.getString("GameRefresher.refresh_counters_test"));
            this.refresher.execute(true, this.nameCheck.isSelected());
        }

        protected void run() {
            this.results.setText("");
            this.refresher.execute(false, this.nameCheck.isSelected());
            this.exit();
        }

        public void addMessage(String mess) {
            this.results.setText(this.results.getText() + "\n" + mess);
        }
    }
}

