/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.LaunchButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RandomTextButton
extends DiceButton {
    protected String[] m_faces;
    protected boolean isNumeric;
    public static final String FACES = "faces";
    public static final String NUMERIC = "numeric";

    public RandomTextButton() {
        ActionListener ranAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RandomTextButton.this.promptAlways) {
                    RandomTextButton.this.promptAlways = false;
                    AutoConfigurer ac = (AutoConfigurer)RandomTextButton.this.getConfigurer();
                    ConfigurerWindow w = new ConfigurerWindow(ac, true);
                    ac.getConfigurer("name").getControls().setVisible(false);
                    ac.getConfigurer("text").getControls().setVisible(false);
                    ac.getConfigurer("tooltip").getControls().setVisible(false);
                    ac.getConfigurer("icon").getControls().setVisible(false);
                    ac.getConfigurer("hotkey").getControls().setVisible(false);
                    ac.getConfigurer("prompt").getControls().setVisible(false);
                    ac.getConfigurer("reportFormat").getControls().setVisible(false);
                    ac.getConfigurer("reportTotal").getControls().setVisible(false);
                    ac.getConfigurer(RandomTextButton.FACES).getControls().setVisible(false);
                    ac.getConfigurer(RandomTextButton.NUMERIC).getControls().setVisible(false);
                    w.pack();
                    w.setVisible(true);
                    ac.getConfigurer("name").getControls().setVisible(true);
                    ac.getConfigurer("text").getControls().setVisible(true);
                    ac.getConfigurer("tooltip").getControls().setVisible(true);
                    ac.getConfigurer("icon").getControls().setVisible(true);
                    ac.getConfigurer("hotkey").getControls().setVisible(true);
                    ac.getConfigurer("prompt").getControls().setVisible(true);
                    ac.getConfigurer("reportFormat").getControls().setVisible(true);
                    ac.getConfigurer("reportTotal").getControls().setVisible(true);
                    ac.getConfigurer(RandomTextButton.FACES).getControls().setVisible(true);
                    ac.getConfigurer(RandomTextButton.NUMERIC).getControls().setVisible(true);
                    if (!w.isCancelled()) {
                        RandomTextButton.this.DR();
                    }
                    RandomTextButton.this.promptAlways = true;
                } else {
                    RandomTextButton.this.DR();
                }
            }
        };
        this.launch = new LaunchButton(null, "tooltip", "text", "hotkey", "icon", ranAction);
        this.setAttributeTranslatable(FACES, true);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.RandomTextButton.component_type");
    }

    @Override
    protected void DR() {
        String report;
        StringBuilder result = new StringBuilder();
        int total = this.addToTotal;
        for (int i = 0; i < this.nDice; ++i) {
            int roll = this.ran.nextInt(this.nSides) + 1;
            if (this.isNumeric) {
                try {
                    if (roll <= this.m_faces.length) {
                        roll = Integer.parseInt(this.m_faces[roll - 1]) + this.plus;
                    } else {
                        ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Dice.random_text_too_few_faces", this.name), String.valueOf(roll)));
                        roll = this.plus;
                    }
                }
                catch (NumberFormatException ex) {
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Dice.random_text_non_numeric", this.name), this.m_faces[roll - 1]));
                    roll = 1;
                }
            }
            if (this.reportTotal && this.isNumeric) {
                total += roll;
                continue;
            }
            if (!this.isNumeric) {
                if (roll <= this.m_faces.length) {
                    result.append(this.m_faces[roll - 1]);
                } else {
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Dice.random_text_too_few_faces", this.name), String.valueOf(roll)));
                    result.append("0");
                }
            } else {
                result.append(roll);
            }
            if (i >= this.nDice - 1) continue;
            result.append(",");
        }
        if (this.reportTotal && this.isNumeric) {
            result.append(total);
        }
        Command c = (report = this.formatResult(result.toString())).length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), report);
        c.execute();
        c.append(this.property.setPropertyValue(result.toString()));
        GameModule.getGameModule().sendAndLog(c);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of("reportTotal", "plus", "addToTotal").contains(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return RandomTextButton.this.isNumeric;
                }
            };
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        l.remove("nSides");
        l.add(FACES);
        l.add(NUMERIC);
        return l.toArray(new String[0]);
    }

    @Override
    public String[] getAttributeDescriptions() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(super.getAttributeDescriptions()));
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        l.remove(names.indexOf("nSides"));
        l.add(Resources.getString("Editor.RandomTextButton.faces"));
        l.add(Resources.getString("Editor.RandomTextButton.faces_numeric"));
        return l.toArray(new String[0]);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        ArrayList l = new ArrayList(Arrays.asList(super.getAttributeTypes()));
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        l.remove(names.indexOf("nSides"));
        l.add(String[].class);
        l.add(Boolean.class);
        return l.toArray(new Class[names.size()]);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NUMERIC.equals(key)) {
            this.isNumeric = Boolean.TRUE.equals(value) || "true".equals(value);
        } else if (FACES.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.m_faces = value;
            this.nSides = this.m_faces.length;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NUMERIC.equals(key)) {
            return String.valueOf(this.isNumeric);
        }
        if (FACES.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.m_faces);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "RandomTextButton");
    }
}

