/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.SpecialDie;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.i18n.Resources;

public class SpecialDieFace
extends AbstractConfigurable {
    public static final String TEXT = "text";
    public static final String NUMERICAL_VALUE = "value";
    public static final String ICON = "icon";
    public static final String IMAGE = "image";
    private int value;
    private String imageName;

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.SpecialDieFace.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.SpecialDieFace.text_value"), Resources.getString("Editor.SpecialDieFace.numeric_value"), Resources.getString("Editor.SpecialDieFace.icon")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, IconConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TEXT, NUMERICAL_VALUE, ICON};
    }

    public String getTextValue() {
        return this.getConfigureName();
    }

    public int getIntValue() {
        return this.value;
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (TEXT.equals(key)) {
            this.setConfigureName((String)o);
        } else if (NUMERICAL_VALUE.equals(key)) {
            try {
                if (o instanceof String) {
                    o = Integer.valueOf((String)o);
                }
                this.value = (Integer)o;
            }
            catch (NumberFormatException e) {
                throw new IllegalBuildException(e);
            }
        } else if (ICON.equals(key)) {
            this.imageName = (String)o;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (TEXT.equals(key)) {
            return this.getConfigureName();
        }
        if (NUMERICAL_VALUE.equals(key)) {
            return String.valueOf(this.value);
        }
        if (ICON.equals(key)) {
            return this.imageName;
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "SpecialDiceButton");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        ((SpecialDie)parent).addFace(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        ((SpecialDie)parent).removeFace(this);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, null);
        }
    }
}

