/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.InstanceConfigurer;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItemInstance;

public abstract class ItemInstance
extends AbstractConfigurable {
    public static final String FG_COLOR = "fgColor";
    public static final String BG_COLOR = "bgColor";
    protected String type = "";
    protected String location = "";
    protected ColorSwatch bgColor = ColorSwatch.getClear();
    protected ColorSwatch fgColor = ColorSwatch.getBlack();
    protected GamePieceImage defn;
    protected Item item;
    protected InstanceConfigurer myConfig = null;

    public ItemInstance(String nam, String typ, String loc) {
        this.setName(nam);
        this.setType(typ);
        this.setLocation(loc);
    }

    public ItemInstance() {
        this("", "", "");
    }

    public ItemInstance(GamePieceImage defn) {
        this();
        this.defn = defn;
    }

    protected void setItem() {
        GamePieceLayout layout;
        if (this.defn != null && (layout = this.defn.getLayout()) != null) {
            this.item = layout.getItem(this.name);
        }
    }

    public Item getItem() {
        if (this.item == null) {
            this.setItem();
        }
        return this.item;
    }

    public void setConfig(InstanceConfigurer i) {
        this.myConfig = i;
    }

    public abstract String encode();

    public static ItemInstance newDefaultInstance(String name, String type, String location) {
        if (type.equals("Symbol")) {
            return new SymbolItemInstance(name, type, location, "Division", "Infantry", "None");
        }
        if (type.equals("Text")) {
            return new TextItemInstance(name, type, location, null);
        }
        if (type.equals("TextBox")) {
            return new TextBoxItemInstance(name, type, location);
        }
        if (type.equals("Box")) {
            return new ShapeItemInstance(name, type, location);
        }
        if (type.equals("Image")) {
            return new ImageItemInstance(name, type, location);
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setBgColor(ColorSwatch bgColor) {
        this.bgColor = bgColor;
    }

    public ColorSwatch getBgColor() {
        return this.bgColor;
    }

    public void setFgColor(ColorSwatch fgColor) {
        this.fgColor = fgColor;
    }

    public ColorSwatch getFgColor() {
        return this.fgColor;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public String getAttributeValueString(String key) {
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof GamePieceImage) {
            this.defn = (GamePieceImage)parent;
        }
    }

    public String getSuffix() {
        return "";
    }

    public String formatName(String name) {
        return name;
    }
}

