/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public abstract class RegularGridNumbering
extends AbstractConfigurable
implements GridNumbering {
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected char first = (char)72;
    protected String sep = "";
    protected char hType = (char)78;
    protected char vType = (char)78;
    protected int hLeading = 1;
    protected int vLeading = 1;
    protected int hOff = 1;
    protected int vOff = 1;
    protected boolean hDescending = false;
    protected boolean vDescending = false;
    protected boolean visible = false;
    protected int fontSize = 9;
    protected Color color = Color.black;
    protected int rotateTextDegrees = 0;
    protected int hDrawOff = 0;
    protected int vDrawOff = 0;
    protected JComponent visualizer;
    protected String locationFormat = "$gridLocation$";
    protected FormattedString format = new FormattedString();
    public static final String FIRST = "first";
    public static final String SEP = "sep";
    public static final String H_TYPE = "hType";
    public static final String V_TYPE = "vType";
    public static final String H_LEADING = "hLeading";
    public static final String V_LEADING = "vLeading";
    public static final String H_OFF = "hOff";
    public static final String V_OFF = "vOff";
    public static final String V_DESCEND = "vDescend";
    public static final String H_DESCEND = "hDescend";
    public static final String FONT_SIZE = "fontSize";
    public static final String COLOR = "color";
    public static final String VISIBLE = "visible";
    public static final String ROTATE_TEXT = "rotateText";
    public static final String H_DRAW_OFF = "hDrawOff";
    public static final String V_DRAW_OFF = "vDrawOff";
    public static final String LOCATION_FORMAT = "locationFormat";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String ROW = "row";
    public static final String COLUMN = "column";
    static final String ALPHABETIC_MATCH = "-?(?:A+|B+|C+|D+|E+|F+|G+|H+|I+|J+|K+|L+|M+|N+|O+|P+|Q+|R+|S+|T+|U+|V+|W+|X+|Y+|Z+)";
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    @Override
    public String getAttributeValueString(String key) {
        if (FIRST.equals(key)) {
            return String.valueOf(this.first);
        }
        if (SEP.equals(key)) {
            return this.sep;
        }
        if (H_TYPE.equals(key)) {
            return String.valueOf(this.hType);
        }
        if (V_TYPE.equals(key)) {
            return String.valueOf(this.vType);
        }
        if (H_LEADING.equals(key)) {
            return String.valueOf(this.hLeading);
        }
        if (V_LEADING.equals(key)) {
            return String.valueOf(this.vLeading);
        }
        if (H_OFF.equals(key)) {
            return String.valueOf(this.hOff);
        }
        if (V_OFF.equals(key)) {
            return String.valueOf(this.vOff);
        }
        if (H_DESCEND.equals(key)) {
            return String.valueOf(this.hDescending);
        }
        if (V_DESCEND.equals(key)) {
            return String.valueOf(this.vDescending);
        }
        if (FONT_SIZE.equals(key)) {
            return String.valueOf(this.fontSize);
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (VISIBLE.equals(key)) {
            return String.valueOf(this.visible);
        }
        if (LOCATION_FORMAT.equals(key)) {
            return this.locationFormat;
        }
        if (ROTATE_TEXT.equals(key)) {
            return String.valueOf(this.rotateTextDegrees);
        }
        if (H_DRAW_OFF.equals(key)) {
            return String.valueOf(this.hDrawOff);
        }
        if (V_DRAW_OFF.equals(key)) {
            return String.valueOf(this.vDrawOff);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (FIRST.equals(key)) {
            this.first = ((String)value).charAt(0);
        } else if (SEP.equals(key)) {
            this.sep = (String)value;
        } else if (H_TYPE.equals(key)) {
            this.hType = ((String)value).charAt(0);
        } else if (V_TYPE.equals(key)) {
            this.vType = ((String)value).charAt(0);
        } else if (H_LEADING.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.hLeading = (Integer)value;
        } else if (V_LEADING.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.vLeading = (Integer)value;
        } else if (H_OFF.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.hOff = (Integer)value;
        } else if (V_OFF.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.vOff = (Integer)value;
        } else if (H_DESCEND.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.hDescending = (Boolean)value;
        } else if (V_DESCEND.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.vDescending = (Boolean)value;
        } else if (FONT_SIZE.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.fontSize = (Integer)value;
        } else if (COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.color = (Color)value;
        } else if (VISIBLE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.visible = (Boolean)value;
        } else if (LOCATION_FORMAT.equals(key)) {
            this.locationFormat = (String)value;
        } else if (ROTATE_TEXT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.rotateTextDegrees = (Integer)value;
        } else if (H_DRAW_OFF.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.hDrawOff = (Integer)value;
        } else if (V_DRAW_OFF.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.vDrawOff = (Integer)value;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public abstract int getRow(Point var1);

    public abstract int getColumn(Point var1);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{FIRST, SEP, H_TYPE, H_LEADING, H_OFF, H_DESCEND, V_TYPE, V_LEADING, V_OFF, V_DESCEND, LOCATION_FORMAT, VISIBLE, FONT_SIZE, COLOR, ROTATE_TEXT, H_DRAW_OFF, V_DRAW_OFF};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Order:  ", "Separator:  ", "Horizontal numbering:  ", "Leading zeros in horizontal:  ", "Starting number in horizontal:  ", "Horizontal numbering descending?", "Vertical numbering:  ", "Leading zeros in vertical:  ", "Starting number in vertical:  ", "Vertical numbering descending?", "Location format:  ", "Draw Numbering?", "Font size:  ", "Color:  ", "Rotate text (Degrees):  ", "Text X offset:  ", "Text Y offset:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{F.class, String.class, T.class, Integer.class, Integer.class, Boolean.class, T.class, Integer.class, Integer.class, Boolean.class, LocationFormatConfig.class, Boolean.class, Integer.class, Color.class, R.class, Integer.class, Integer.class};
    }

    protected abstract JComponent getGridVisualizer();

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (FONT_SIZE.equals(name) || COLOR.equals(name)) {
            VisibilityCondition cond = new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.visible;
                }
            };
            return cond;
        }
        if (H_LEADING.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.hType == 'N';
                }
            };
        }
        if (V_LEADING.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.vType == 'N';
                }
            };
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public Configurer getConfigurer() {
        String[] s;
        AutoConfigurer c = (AutoConfigurer)super.getConfigurer();
        for (String value : s = this.getAttributeNames()) {
            c.getConfigurer(value).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    RegularGridNumbering.this.visualizer.repaint();
                }
            });
        }
        ((Container)c.getControls()).add(this.getGridVisualizer());
        return c;
    }

    public static String getConfigureTypeName() {
        return "Grid Numbering";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GridNumbering.htm");
    }

    protected String getName(int row, int column) {
        String rowName = this.getName(row + this.vOff, this.vType, this.vLeading);
        String colName = this.getName(column + this.hOff, this.hType, this.hLeading);
        switch (this.first) {
            case 'H': {
                return colName + this.sep + rowName;
            }
        }
        return rowName + this.sep + colName;
    }

    protected String getMatchingPattern(char type, int leading) {
        if (type == 'A') {
            return ALPHABETIC_MATCH;
        }
        return "-?[0-9]{" + (leading + 1) + ",}";
    }

    @Override
    public Point getLocation(String location) throws MapGrid.BadCoords {
        SequenceEncoder.Decoder se = new SequenceEncoder.Decoder(this.locationFormat, '$');
        boolean isProperty = true;
        StringBuilder regex = new StringBuilder();
        int colGroup = 0;
        int rowGroup = 0;
        int groupCount = 0;
        while (se.hasMoreTokens()) {
            String token = se.nextToken();
            boolean bl = isProperty = !isProperty;
            if (token.length() <= 0) continue;
            if (!isProperty || !se.hasMoreTokens()) {
                regex.append(Pattern.quote(token));
                continue;
            }
            if (token.equals(GRID_LOCATION)) {
                if (this.first == 'H') {
                    regex.append('(').append(this.getMatchingPattern(this.hType, this.hLeading)).append(')');
                    colGroup = ++groupCount;
                    if (this.sep.length() > 0) {
                        regex.append(Pattern.quote(this.sep));
                    }
                    regex.append('(').append(this.getMatchingPattern(this.vType, this.vLeading)).append(')');
                    rowGroup = ++groupCount;
                    continue;
                }
                regex.append('(').append(this.getMatchingPattern(this.vType, this.vLeading)).append(')');
                rowGroup = ++groupCount;
                regex.append(Pattern.quote(this.sep));
                regex.append('(').append(this.getMatchingPattern(this.hType, this.hLeading)).append(')');
                colGroup = ++groupCount;
                continue;
            }
            if (token.equals(ROW)) {
                regex.append('(').append(this.getMatchingPattern(this.vType, this.vLeading)).append(')');
                rowGroup = ++groupCount;
                continue;
            }
            if (!token.equals(COLUMN)) continue;
            regex.append('(').append(this.getMatchingPattern(this.hType, this.hLeading)).append(')');
            colGroup = ++groupCount;
        }
        if (regex.length() == 0 || colGroup == 0 || rowGroup == 0) {
            throw new MapGrid.BadCoords();
        }
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(location);
        if (!matcher.matches()) {
            throw new MapGrid.BadCoords();
        }
        assert (matcher.groupCount() == groupCount && groupCount >= 2);
        String rowName = location.substring(matcher.start(rowGroup), matcher.end(rowGroup));
        String colName = location.substring(matcher.start(colGroup), matcher.end(colGroup));
        int row = this.parseName(rowName, this.vType);
        int col = this.parseName(colName, this.hType);
        return this.getCenterPoint(col - this.hOff, row - this.vOff);
    }

    public abstract Point getCenterPoint(int var1, int var2);

    @Override
    public String locationName(Point pt) {
        int row = this.getRow(pt);
        int col = this.getColumn(pt);
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(GRID_LOCATION, this.getName(row, col));
        this.format.setProperty(ROW, this.getName(row + this.vOff, this.vType, this.vLeading));
        this.format.setProperty(COLUMN, this.getName(col + this.hOff, this.hType, this.hLeading));
        return this.format.getLocalizedText();
    }

    @Override
    public String localizedLocationName(Point pt) {
        return this.locationName(pt);
    }

    protected int parseName(String name, char type) {
        int value = 0;
        switch (type) {
            case 'A': {
                int index = 0;
                boolean negative = false;
                if (name.startsWith("-")) {
                    negative = true;
                    ++index;
                }
                while (index < name.length() && Character.isUpperCase(name.charAt(index))) {
                    value = index < name.length() - 1 ? (value += 26) : (value += ALPHABET.indexOf(name.charAt(index)));
                    ++index;
                }
                if (!negative) break;
                value *= -1;
                break;
            }
            default: {
                value = Integer.parseInt(name);
            }
        }
        return value;
    }

    protected String getName(int rowOrColumn, char type, int leading) {
        Object val = rowOrColumn < 0 ? "-" : "";
        rowOrColumn = Math.abs(rowOrColumn);
        switch (type) {
            case 'A': {
                do {
                    val = (String)val + ALPHABET.charAt(rowOrColumn % 26);
                } while ((rowOrColumn -= 26) >= 0);
                return val;
            }
        }
        while (leading > 0) {
            int n = leading--;
            if (!((double)rowOrColumn < Math.pow(10.0, n))) break;
            val = (String)val + "0";
        }
        return (String)val + rowOrColumn;
    }

    public Point offsetLabelCenter(Point p, double zoom) {
        return this.offsetLabelCenter(p.x, p.y, zoom);
    }

    public Point offsetLabelCenter(int x, int y, double zoom) {
        Point n = new Point(x, y);
        switch (this.rotateTextDegrees) {
            case 0: {
                break;
            }
            case 90: {
                n.x = y;
                n.y = -x;
                break;
            }
            case 180: {
                n.x = -x;
                n.y = -y;
                break;
            }
            case 270: {
                n.x = -y;
                n.y = x;
                break;
            }
        }
        n.x = (int)((double)n.x + (double)this.hDrawOff * zoom);
        n.y = (int)((double)n.y + (double)this.vDrawOff * zoom);
        return n;
    }

    public static class F
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{"Horizontal first", "Vertical first"};
        }
    }

    public static class T
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{"Numerical", "Alphabetic"};
        }
    }

    public static class LocationFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedStringConfigurer(key, name, new String[]{RegularGridNumbering.GRID_LOCATION, RegularGridNumbering.ROW, RegularGridNumbering.COLUMN});
        }
    }

    public static class R
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{"0", "90", "180", "270"};
        }
    }
}

