/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.HybridClient;
import VASSAL.chat.Room;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberRoom;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.LockableRoomControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class LockableJabberRoomControls
extends LockableRoomControls {
    protected ActionListener extendedRoomCreator;

    @Override
    public void initializeControls(ChatServerControls controls) {
        super.initializeControls(controls);
        this.extendedRoomCreator = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LockableJabberRoomControls.this.client.isConnected()) {
                    String name;
                    Properties props = JabberRoom.configureNewRoom();
                    if (props != null && (name = props.getProperty("name")).length() > 0) {
                        LockableJabberRoomControls.this.createRoom(props);
                    }
                } else {
                    GameModule.getGameModule().warn(Resources.getString("Chat.must_connect"));
                }
            }
        };
        controls.addExtendedNewRoomHandler(this.extendedRoomCreator);
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        super.uninitializeControls(controls);
        controls.removeExtendedNewRoomHandler(this.extendedRoomCreator);
    }

    public LockableJabberRoomControls(JabberClient client) {
        super(client);
    }

    @Override
    protected void addLockRoomAction(JPopupMenu popup, Room target) {
        JabberClient c = this.getJabberClient();
        if (c != null) {
            popup.add(new LockRoomAction((JabberRoom)target, c));
        }
    }

    @Override
    public JPopupMenu buildPopupForRoom(Room target, JTree tree) {
        JPopupMenu popup = super.buildPopupForRoom(target, tree);
        popup.add(new RoomPropertiesAction((JabberRoom)target));
        return popup;
    }

    private JabberClient getJabberClient() {
        JabberClient c = null;
        if (this.client instanceof JabberClient) {
            c = (JabberClient)this.client;
        } else if (this.client instanceof HybridClient && ((HybridClient)this.client).getDelegate() instanceof JabberClient) {
            c = (JabberClient)((HybridClient)this.client).getDelegate();
        }
        return c;
    }

    protected void createRoom(Properties props) {
        JabberRoom room = ((JabberClient)this.client).getRoomByName(props.getProperty("name"));
        room.setConfig(props);
        this.client.setRoom(room);
    }

    @Override
    protected void createRoom(String name) {
        if (this.client.isConnected()) {
            if (name != null && name.length() > 0) {
                JabberRoom room = ((JabberClient)this.client).getRoomByName(name);
                this.client.setRoom(room);
            }
        } else {
            GameModule.getGameModule().warn(Resources.getString("Chat.must_connect"));
        }
    }

    class LockRoomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JabberClient client;
        private JabberRoom target;

        public LockRoomAction(JabberRoom target, JabberClient client) {
            super(target.isLocked() ? Resources.getString("Chat.unlock_room") : Resources.getString("Chat.lock_room"));
            this.setEnabled(target.isOwnedByMe() && !target.getName().equals(client.getDefaultRoomName()));
            this.target = target;
            this.client = client;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.client.lockRoom(this.target);
        }
    }

    class RoomPropertiesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JabberRoom target;

        public RoomPropertiesAction(JabberRoom room) {
            super(Resources.getString("General.properties"));
            this.target = room;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.target.showConfig();
        }
    }
}

