/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.peer2peer.AcceptPeerThread;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.PlayerWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.Dialogs;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;

public class DirectPeerPool
implements PeerPool,
ChatControlsInitializer {
    protected static final String ADDRESS_PREF = "PeerAddressBook";
    private AcceptPeerThread acceptThread;
    private final JButton inviteButton;
    private JDialog frame;
    private static StringArrayConfigurer addressConfig;
    private JList<Entry> addressList;
    private DefaultListModel<Entry> addressBook;
    private final Properties params = new Properties();

    public DirectPeerPool() {
        this(new Properties());
    }

    public DirectPeerPool(Properties param) {
        this.params.putAll((Map<?, ?>)param);
        this.inviteButton = new JButton(Resources.getString("Peer2Peer.connect"));
        this.inviteButton.addActionListener(e -> this.frame.setVisible(true));
        this.inviteButton.setEnabled(false);
        this.inviteButton.setVisible(true);
    }

    @Override
    public void initialize(P2PPlayer myInfo, PendingPeerManager ppm) throws IOException {
        int listenPort = 5050;
        String port = this.params.getProperty("listenPort");
        if (port != null && port.length() > 0) {
            try {
                listenPort = Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.acceptThread = new AcceptPeerThread(listenPort, ppm);
        this.acceptThread.setName("Accept Peer Thread");
        myInfo.getInfo().setPort(this.acceptThread.getPort());
        this.acceptThread.start();
        if (this.frame == null) {
            this.initComponents(myInfo, ppm);
            this.inviteButton.setEnabled(true);
        }
    }

    @Deprecated(since="2020-08-17", forRemoval=true)
    protected boolean isServerMode() {
        return true;
    }

    @Override
    public void disconnect() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
            this.inviteButton.setEnabled(false);
        }
        if (this.acceptThread != null) {
            this.acceptThread.halt();
            this.acceptThread = null;
        }
    }

    @Override
    public void connectFailed(PeerInfo peerInfo) {
        JOptionPane.showMessageDialog(this.frame, Resources.getString("Peer2Peer.could_not_reach", peerInfo.getAddresses(), String.valueOf(peerInfo.getPort())), Resources.getString("Peer2Peer.invite_failed"), 1);
    }

    public void initComponents(P2PPlayer me, PendingPeerManager ppm) {
        if (addressConfig == null) {
            addressConfig = new StringArrayConfigurer(ADDRESS_PREF, null);
            Prefs.getGlobalPrefs().addOption(null, addressConfig);
        }
        String[] encodedEntries = addressConfig.getStringArray();
        this.addressBook = new DefaultListModel();
        this.addressList = new JList<Entry>(this.addressBook);
        for (String e2 : encodedEntries) {
            this.addToList(new Entry(e2));
        }
        PlayerWindow owner = null;
        if (GameModule.getGameModule() != null) {
            owner = GameModule.getGameModule().getPlayerWindow();
        }
        this.frame = new JDialog((Frame)owner, Resources.getString("Peer2Peer.direct_connection"));
        this.frame.setDefaultCloseOperation(1);
        this.frame.setLayout((LayoutManager)new MigLayout());
        this.frame.add((Component)new WTextArea(Resources.getString("Peer2Peer.other_players_address")), "growx, span 4,wrap");
        JScrollPane scroll = new JScrollPane(this.addressList);
        this.frame.add((Component)scroll, "span 4, grow, push, w 300, h 400, wrap");
        JButton invitePeerButton = new JButton(Resources.getString("Peer2Peer.connect"));
        invitePeerButton.setToolTipText(Resources.getString("Peer2Peer.invite_button_tooltip"));
        invitePeerButton.addActionListener(e -> this.invite(ppm));
        this.frame.add((Component)invitePeerButton, "growx, push");
        JButton addButton = new JButton(Resources.getString("General.add"));
        addButton.setToolTipText(Resources.getString("Peer2Peer.add_button_tooltip"));
        addButton.addActionListener(e -> this.addEntry());
        this.frame.add((Component)addButton, "growx, push");
        JButton editButton = new JButton(Resources.getString("General.edit"));
        editButton.setToolTipText(Resources.getString("Peer2Peer.edit_button_tooltip"));
        editButton.addActionListener(e -> this.editEntry());
        this.frame.add((Component)editButton, "growx, push");
        JButton removeButton = new JButton(Resources.getString("General.remove"));
        removeButton.setToolTipText(Resources.getString("Peer2Peer.remove_button_tooltip"));
        removeButton.addActionListener(arg0 -> this.removeEntries());
        this.frame.add((Component)removeButton, "growx, push, wrap");
        this.frame.pack();
        this.frame.setLocationRelativeTo(owner);
    }

    protected void invite(PendingPeerManager ppm) {
        int[] selected;
        for (int value : selected = this.addressList.getSelectedIndices()) {
            Entry entry = this.addressBook.getElementAt(value);
            PeerInfo info = PeerInfo.deFormat(entry.getAddress() + ":" + entry.getPort() + " " + entry.getDescription());
            if (info != null) {
                ppm.addNewPeer(info);
                GameModule.getGameModule().warn(Resources.getString("Chat.invite_sent", entry.toString()));
                continue;
            }
            JOptionPane.showMessageDialog(this.frame, Resources.getString("Peer2Peer.invalid_format"));
        }
    }

    protected void addEntry() {
        Entry e = new Entry();
        if (e.edit() && !this.addressBook.contains(e)) {
            this.addToList(e);
            this.saveAddressBook();
        }
    }

    protected void addToList(Entry e) {
        boolean added = false;
        for (int i = 0; i < this.addressBook.getSize() && !added; ++i) {
            if (e.compareTo(this.addressBook.getElementAt(i)) >= 0) continue;
            this.addressBook.insertElementAt(e, i);
            added = true;
        }
        if (!added) {
            this.addressBook.addElement(e);
        }
    }

    protected void editEntry() {
        Entry e;
        int index = this.addressList.getSelectedIndex();
        if (index >= 0 && (e = this.addressBook.getElementAt(index)).edit()) {
            this.addressBook.removeElementAt(index);
            this.addToList(e);
            this.saveAddressBook();
        }
    }

    protected void removeEntries() {
        int[] selected = this.addressList.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        Entry[] entries = new Entry[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            entries[i] = this.addressBook.getElementAt(selected[i]);
        }
        JPanel queryPanel = new JPanel((LayoutManager)new MigLayout("", "10[][]10"));
        String mess = entries.length == 1 ? Resources.getString("Peer2Peer.remove_entry") : Resources.getString("Peer2Peer.remove_entries", entries.length);
        queryPanel.add((Component)new JLabel(mess), "align center, wrap");
        queryPanel.add((Component)new JLabel(), "wrap");
        for (Entry entry : entries) {
            queryPanel.add((Component)new JLabel(entry.toString()), "wrap");
        }
        Integer result = (Integer)Dialogs.showDialog(null, Resources.getString("Peer2Peer.remove_entry"), queryPanel, 3, null, 2, null, null, null, null);
        if (result != null && result == 0) {
            for (Entry entry : entries) {
                this.addressBook.removeElement(entry);
            }
            this.saveAddressBook();
        }
    }

    protected void saveAddressBook() {
        String[] entries = new String[this.addressBook.size()];
        int i = 0;
        Enumeration<Entry> e = this.addressBook.elements();
        while (e.hasMoreElements()) {
            entries[i++] = e.nextElement().encode();
        }
        addressConfig.setValue(entries);
    }

    @Override
    public void initializeControls(ChatServerControls controls) {
        controls.getToolbar().add(this.inviteButton);
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        controls.getToolbar().remove(this.inviteButton);
        controls.getToolbar().repaint();
    }

    private static class Entry
    implements Comparable<Entry> {
        String description;
        String address;
        String port;
        JTextField descriptionField;
        JTextField addressField;
        JTextField portField;

        public Entry() {
            this("", "", "5050", "");
        }

        public Entry(String description, String address, String port, String passwd) {
            this.description = description;
            this.address = address;
            this.port = port;
        }

        public Entry(String s) {
            this.decode(s);
        }

        public String getDescription() {
            return this.description;
        }

        public String getAddress() {
            return this.address;
        }

        public String getPort() {
            return this.port;
        }

        public String toString() {
            return this.description + " [" + this.address + ":" + this.port;
        }

        private void decode(String s) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '|');
            this.description = sd.nextToken("");
            this.address = sd.nextToken("");
            this.port = sd.nextToken("5050");
        }

        public String encode() {
            SequenceEncoder se = new SequenceEncoder('|');
            se.append(this.description);
            se.append(this.address);
            se.append(this.port);
            return se.getValue();
        }

        @Override
        public int compareTo(Entry e) {
            return this.toString().compareTo(e.toString());
        }

        public boolean edit() {
            this.descriptionField = new JTextField(this.description);
            this.addressField = new JTextField(this.address);
            this.portField = new JTextField(this.port);
            JPanel editPanel = new JPanel((LayoutManager)new MigLayout("", "[align right]rel[]", ""));
            editPanel.add(new JLabel(Resources.getString("Editor.description_label")));
            editPanel.add((Component)this.descriptionField, "wrap, grow, push");
            editPanel.add(new JLabel(Resources.getString("Chat.ip_address")));
            editPanel.add((Component)this.addressField, "wrap, grow, push");
            editPanel.add(new JLabel(Resources.getString("ServerAddressBook.port")));
            editPanel.add((Component)this.portField, "wrap, grow, push");
            Integer result = (Integer)Dialogs.showDialog(null, Resources.getString("Peer2Peer.add_peer_connection"), editPanel, -1, null, 2, null, null, null, null);
            if (result != null && result == 0) {
                this.description = this.descriptionField.getText();
                this.address = this.addressField.getText();
                this.port = this.portField.getText();
                return true;
            }
            return false;
        }
    }

    private static class WTextArea
    extends JTextArea {
        private static final long serialVersionUID = 1L;

        public WTextArea(String s) {
            super(s);
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setBackground(UIManager.getColor("OptionPane.background"));
        }
    }
}

