/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.script.expression.FunctionBuilder;
import VASSAL.script.expression.IntBuilder;
import VASSAL.script.expression.StrBuilder;
import VASSAL.tools.menu.MenuScroller;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class BeanShellFunctionMenu
extends JPopupMenu {
    protected static final String[] SUM_COUNT_HINTS = new String[]{"WARNING - This function needs to scan many pieces and is relatively slow. Use sparingly", "$property$ variables may be used in the Match Expression and will be evaluated on the source piece.", "See the Reference Manual for detailed usage."};
    protected static int maxScrollItems = 0;
    protected BeanShellExpressionConfigurer configurer;
    protected EditablePiece target;

    public BeanShellFunctionMenu(EditablePiece target, BeanShellExpressionConfigurer configurer) {
        this.target = target;
        this.configurer = configurer;
        JMenu constantMenu = new JMenu("Constant");
        JMenuItem integerItem = new JMenuItem("Number");
        integerItem.setToolTipText("A number");
        integerItem.addActionListener(e -> this.buildInteger());
        constantMenu.add(integerItem);
        JMenuItem stringItem = new JMenuItem("String");
        stringItem.setToolTipText("A character string");
        stringItem.addActionListener(e -> this.buildString());
        constantMenu.add(stringItem);
        this.add(constantMenu);
        JMenu propertyMenu = new JMenu("Property");
        if (target != null) {
            JMenu pieceMenu = new JMenu("Piece Property");
            this.addProp(pieceMenu, "Moved");
            this.addProp(pieceMenu, "Selected");
            this.addProp(pieceMenu, "PieceId");
            this.addPieceProps(pieceMenu, target);
            propertyMenu.add(pieceMenu);
        }
        JMenu globalsMenu = new JMenu("Global Property");
        this.buildGlobalMenu(globalsMenu, GameModule.getGameModule(), true);
        propertyMenu.add(globalsMenu);
        JMenu vassalMenu = new JMenu("Vassal Property");
        this.addProp(vassalMenu, "PlayerSide");
        this.addProp(vassalMenu, "PlayerName");
        this.addProp(vassalMenu, "PlayerId");
        propertyMenu.add(vassalMenu);
        this.add(propertyMenu);
        JMenu operatorMenu = new JMenu("Operator");
        this.addOperator(operatorMenu, "+", "Add");
        this.addOperator(operatorMenu, "-", "Subtract");
        this.addOperator(operatorMenu, "*", "Multiply");
        this.addOperator(operatorMenu, "/", "Divide");
        this.addOperator(operatorMenu, "%", "Modulus");
        this.add(operatorMenu);
        JMenu comparisonMenu = new JMenu("Comparison");
        this.addOperator(comparisonMenu, "==", "Equals");
        this.addOperator(comparisonMenu, "!=", "Not equals");
        this.addOperator(comparisonMenu, ">", "Greater than");
        this.addOperator(comparisonMenu, ">=", "Greater than or equal to");
        this.addOperator(comparisonMenu, "<", "Less than");
        this.addOperator(comparisonMenu, "<=", "Less than or equal to");
        this.addOperator(comparisonMenu, "=~", "Matches Regular Expression");
        this.addOperator(comparisonMenu, "!~", "Does not match Regular Expression");
        this.add(comparisonMenu);
        JMenu logicalMenu = new JMenu("Logical");
        this.addOperator(logicalMenu, "&&", "And");
        this.addOperator(logicalMenu, "||", "Or");
        this.addOperator(logicalMenu, "!", "Not");
        this.addOperator(logicalMenu, "(", "Left parenthesis");
        this.addOperator(logicalMenu, ")", "Right parenthesis");
        this.add(logicalMenu);
        JMenu mathMenu = new JMenu("Math");
        this.addFunction(mathMenu, "Math.abs", "Absolute value of a number", new String[]{"Number"}, "(n)");
        this.addFunction(mathMenu, "Math.min", "Minimum of two numbers", new String[]{"Number 1", "Number 2"}, "(m, n)");
        this.addFunction(mathMenu, "Math.max", "Maximum of two numbers", new String[]{"Number 1", "Number 2"}, "(m, n)");
        JMenu propMenu = new JMenu("Property");
        this.addFunction(propMenu, "GetProperty", "Get the value of a property", new String[]{"Property name"}, "(prop)");
        this.addFunction(propMenu, "GetMapProperty", "Get the value of a Map-level property", new String[]{"Property name", "Map name"}, "(prop, map)");
        this.addFunction(propMenu, "GetZoneProperty", "Get the value of a Zone-level property on the current Map", new String[]{"Property name", "Zone name"}, "(prop, zone)");
        this.addFunction(propMenu, "GetZoneProperty", "Get the value of a Zone-level property on any Map", new String[]{"Property name", "Zone name", "Map name"}, "(prop, zone, map)");
        JMenu stringMenu = new JMenu("String");
        this.addFunction(stringMenu, ".length", "Return the length of a string", new String[]{"Target String"}, "()");
        this.addFunction(stringMenu, ".contains", "Return true if string contains the specified search string", new String[]{"Target String", "Search String"}, "(string)");
        this.addFunction(stringMenu, ".startsWith", "Return true if string starts with the specified search string", new String[]{"Target String", "Search String"}, "(string)");
        this.addFunction(stringMenu, ".endsWith", "Return true if string ends with the specified search string", new String[]{"Target String", "String String"}, "(string)");
        this.addFunction(stringMenu, ".matches", "Return true if string matches the specified Regular Expression", new String[]{"Target String", "Regular Expression"}, "(regExpr)");
        this.addFunction(stringMenu, ".indexOf", "Return the position of the specified search string", new String[]{"Target String", "Search String"}, "(string)");
        this.addFunction(stringMenu, ".lastIndexOf", "Return the last position of the specified search string", new String[]{"Target String", "Search String"}, "(string)");
        this.addFunction(stringMenu, ".substring", "Return substring starting at a given position, up to the end of the string", new String[]{"Target String", "Starting position"}, "(start)");
        this.addFunction(stringMenu, ".substring", "Return substring between positions", new String[]{"Target String", "Starting position", "End Position"}, "(start, end)");
        this.addFunction(stringMenu, ".replace", "Replace one substring with another", new String[]{"Target String", "String to find", "String to replace"}, "(old, new)");
        JMenu randomMenu = new JMenu("Random");
        this.addFunction(randomMenu, "Random", "Return a random whole number between 1 and a number (inclusive)", new String[]{"Highest number"}, "(x)");
        this.addFunction(randomMenu, "Random", "Return a random whole number between 2 numbers (inclusive)", new String[]{"Lowest number", "Highest number"}, "(x, y)");
        this.addFunction(randomMenu, "IsRandom", "Return true randomly 50% of the time", new String[0], "()");
        this.addFunction(randomMenu, "IsRandom", "Return true randomly a specified % of the time", new String[]{"Percent"}, "(p)");
        JMenu countMenu = new JMenu("Sum & Count");
        this.addFunction(countMenu, "SumStack", "Sum the values of the named property in all pieces in the same stack", new String[]{"Property name"}, "(name)");
        this.addFunction(countMenu, "Sum", "Sum the values of the named property in matching pieces on all maps", new String[]{"Property name", "Property match expression"}, "(name, expr)", SUM_COUNT_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(countMenu, "Sum", "Sum the values of the named property in matching pieces on the named map", new String[]{"Property name", "Property match expression", "Map Name"}, "(name, expr, map)", SUM_COUNT_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME, BeanShellExpressionConfigurer.Option.NONE});
        this.addFunction(countMenu, "Count", "Count the number of matching pieces on all maps", new String[]{"Property match expression"}, "(expr)", SUM_COUNT_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(countMenu, "Count", "Count the number of matching pieces on the named map", new String[]{"Property match expression", "Map Name"}, "(expr, map)", SUM_COUNT_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME, BeanShellExpressionConfigurer.Option.NONE});
        JMenu functionMenu = new JMenu("Function");
        functionMenu.add(mathMenu);
        functionMenu.add(propMenu);
        functionMenu.add(randomMenu);
        functionMenu.add(stringMenu);
        functionMenu.add(countMenu);
        this.addFunction(functionMenu, "?", "Return a different result depending on a logical expression", new String[]{"Logical expression", "Result if true", "Result if false"}, "(expr ? r1 : r2)");
        this.addFunction(functionMenu, "Alert", "Display text in a Dialog box", new String[]{"Text to display"}, "(text)");
        this.add(functionMenu);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo) {
        this.addFunction(menu, op, desc, parms, parmInfo, null);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo, String[] hints) {
        BeanShellExpressionConfigurer.Option[] options = new BeanShellExpressionConfigurer.Option[parms.length];
        Arrays.fill((Object[])options, (Object)BeanShellExpressionConfigurer.Option.NONE);
        this.addFunction(menu, op, desc, parms, parmInfo, hints, options);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo, String[] hints, BeanShellExpressionConfigurer.Option[] options) {
        JMenuItem item = new JMenuItem(op + (String)(parmInfo != null && parmInfo.length() == 0 ? "" : " " + parmInfo));
        item.setToolTipText(desc);
        item.addActionListener(e -> this.buildFunction(op, desc, parms, hints, options));
        menu.add(item);
    }

    protected void buildFunction(String op, String desc, String[] parmDesc, String[] hints, BeanShellExpressionConfigurer.Option[] options) {
        if (parmDesc.length == 0) {
            this.configurer.insertName(op + "()");
        } else {
            StringConfigurer result = new StringConfigurer(null, "", "");
            new FunctionBuilder(result, (JDialog)this.configurer.getTopLevelAncestor(), op, desc, parmDesc, this.target, hints, options, this.configurer.getSelectedText()).setVisible(true);
            if (result.getValue() != null && result.getValueString().length() > 0) {
                this.configurer.insertName(result.getValueString());
            }
        }
    }

    protected void buildInteger() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new IntBuilder(result, (JDialog)this.configurer.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.configurer.insertName(result.getValueString());
        }
    }

    protected void buildString() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new StrBuilder(result, (JDialog)this.configurer.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.configurer.insertName(result.getValueString());
        }
    }

    protected void addOperator(JMenu menu, String op, String desc) {
        JMenuItem item = new JMenuItem(op);
        item.setToolTipText(desc);
        item.addActionListener(e -> this.configurer.insertName(op));
        menu.add(item);
    }

    protected void addProp(JMenu menu, String propName) {
        this.addProp(menu, propName, false);
    }

    protected void addProp(JMenu menu, String propName, boolean sort) {
        if (propName == null) {
            return;
        }
        JMenuItem item = new JMenuItem(propName);
        item.addActionListener(e -> this.configurer.insertPropertyName(propName));
        if (sort) {
            int pos = -1;
            for (int i = 0; i < menu.getItemCount() && pos < 0; ++i) {
                if (propName.compareTo(menu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            menu.add((Component)item, pos);
        } else {
            menu.add(item);
        }
    }

    protected void addPieceProps(JMenu menu, EditablePiece piece) {
        if (piece == null) {
            return;
        }
        JMenu pieceMenu = null;
        if (piece instanceof PropertyNameSource) {
            List<String> propNames = ((PropertyNameSource)((Object)piece)).getPropertyNames();
            for (String propName : propNames) {
                if (pieceMenu == null) {
                    pieceMenu = new JMenu();
                    pieceMenu.setText(piece.getDescription());
                }
                JMenuItem item = new JMenuItem(propName);
                item.addActionListener(e -> this.configurer.insertPropertyName(((JMenuItem)e.getSource()).getText()));
                pieceMenu.add(item);
            }
            if (pieceMenu != null) {
                menu.add(pieceMenu);
            }
            if (piece instanceof Decorator) {
                this.addPieceProps(menu, (EditablePiece)((Decorator)((Object)piece)).getInner());
            }
        }
    }

    protected void buildGlobalMenu(JMenu parentMenu, AbstractBuildable target, boolean useParentMenu) {
        String n;
        List<Buildable> buildables = target.getBuildables();
        Object menuName = ConfigureTree.getConfigureName(target.getClass());
        if (target instanceof AbstractConfigurable && (n = ((AbstractConfigurable)target).getConfigureName()) != null && n.length() > 0) {
            menuName = (String)menuName + " " + n;
        }
        JMenu myMenu = new JMenu((String)menuName);
        List<String> propNames = target.getPropertyNames();
        for (String propName : propNames) {
            this.addProp(useParentMenu ? parentMenu : myMenu, propName, true);
        }
        for (Buildable b : buildables) {
            if (b instanceof AbstractConfigurable) {
                boolean useParent = b instanceof GlobalProperties || b instanceof Board || b instanceof ZonedGrid;
                this.buildGlobalMenu(useParentMenu ? parentMenu : myMenu, (AbstractConfigurable)b, useParent);
                continue;
            }
            if (!(b instanceof BoardPicker)) continue;
            this.buildGlobalMenu(myMenu, (AbstractBuildable)b, true);
        }
        if (!useParentMenu & myMenu.getItemCount() > 0) {
            MenuScroller.setScrollerFor(myMenu, this.getMaxScrollItems(), 100);
            int pos = -1;
            for (int i = 0; i < parentMenu.getItemCount() && pos < 0; ++i) {
                if (myMenu.getText().compareTo(parentMenu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            parentMenu.add((Component)myMenu, pos);
        }
    }

    protected int getMaxScrollItems() {
        if (maxScrollItems == 0) {
            Dimension itemSize = new JMenuItem("Testing").getPreferredSize();
            maxScrollItems = (int)(0.8 * (double)Toolkit.getDefaultToolkit().getScreenSize().height / (double)itemSize.height);
        }
        return maxScrollItems;
    }
}

