/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Configurable;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.i18n.Resources;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;

public class EditPropertiesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected Configurable target;
    protected HelpWindow helpWindow;
    protected static Map<Configurable, PropertiesWindow> openWindows = new HashMap<Configurable, PropertiesWindow>();
    protected Frame dialogOwner;
    protected ConfigureTree tree;

    public EditPropertiesAction(Configurable target, HelpWindow helpWindow, Frame dialogOwner) {
        super(Resources.getString("Editor.ModuleEditor.properties"));
        this.helpWindow = helpWindow;
        this.target = target;
        this.dialogOwner = dialogOwner;
        this.setEnabled(target.getConfigurer() != null);
    }

    public EditPropertiesAction(Configurable target, HelpWindow helpWindow, Frame dialogOwner, ConfigureTree tree) {
        this(target, helpWindow, dialogOwner);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PropertiesWindow w = openWindows.get(this.target);
        if (w == null) {
            w = new PropertiesWindow(this.dialogOwner, false, this.target, this.helpWindow);
            w.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    openWindows.remove(EditPropertiesAction.this.target);
                    if (EditPropertiesAction.this.tree != null && EditPropertiesAction.this.target instanceof ConfigureTree.Mutable) {
                        EditPropertiesAction.this.tree.nodeUpdated(EditPropertiesAction.this.target);
                    }
                }
            });
            openWindows.put(this.target, w);
            w.setVisible(true);
            if (this.tree != null) {
                this.tree.notifyStateChanged(true);
            }
        }
        w.toFront();
    }
}

