/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameRefresher;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PluginsLoader;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.gamepieceimage.GamePieceImageDefinitions;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.chat.AddressBookServerConfigurer;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClient;
import VASSAL.chat.DynamicClientFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.jabber.JabberClientFactory;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.password.ToggleablePasswordConfigurer;
import VASSAL.i18n.Language;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicModule
extends GameModule {
    private static final Logger log = LoggerFactory.getLogger(BasicModule.class);
    private static char COMMAND_SEPARATOR = (char)27;
    protected ChatServerControls serverControls;
    protected GameRefresher gameRefresher;

    public BasicModule(DataArchive archive) {
        super(archive);
    }

    @Override
    protected void build() throws IOException {
        DataArchive darch = this.getDataArchive();
        File f = new File(darch.getName());
        if (!f.exists() || f.length() == 0L) {
            this.build(null);
        } else {
            try (InputStream inner = darch.getInputStream("buildFile");
                 BufferedInputStream in = new BufferedInputStream(inner);){
                Document doc = Builder.createDocument(in);
                this.build(doc.getDocumentElement());
            }
            catch (IOException e) {
                throw new IOException(Resources.getString("BasicModule.not_a_module"), e);
            }
        }
        MenuManager.getInstance().addAction("Prefs.edit_preferences", this.getPrefs().getEditor().getEditAction());
        this.gameRefresher = new GameRefresher(this);
        this.gameRefresher.addTo(this);
        MenuManager.getInstance().addAction("GameRefresher.refresh_counters", this.gameRefresher.getRefreshAction());
    }

    @Override
    public void build(Element e) {
        if (e != null) {
            this.gameName = e.getAttribute("name");
            if (e.getAttribute("VassalVersion").length() > 0) {
                this.vassalVersionCreated = e.getAttribute("VassalVersion");
            }
        }
        this.initIdentityPreferences();
        this.initImagePreferences();
        Prefs.initSharedGlobalPrefs();
        this.initGameState();
        this.initLogger();
        this.initServer();
        new PluginsLoader().addTo(this);
        if (e != null) {
            super.build(e);
            this.ensureComponent(GamePieceImageDefinitions.class);
            this.ensureComponent(GlobalProperties.class);
            this.ensureComponent(Language.class);
        } else {
            this.buildDefaultComponents();
        }
        this.initFrame();
    }

    protected void initIdentityPreferences() {
        this.idChangeSupport = new PropertyChangeSupport(this);
        StringConfigurer fullName = new StringConfigurer("RealName", Resources.getString("Prefs.name_label"), Resources.getString("Prefs.newbie"));
        fullName.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BasicModule.this.idChangeSupport.firePropertyChange(evt);
            }
        });
        TextConfigurer profile = new TextConfigurer("Profile", Resources.getString("Prefs.personal_info"), "");
        profile.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BasicModule.this.idChangeSupport.firePropertyChange(evt);
            }
        });
        ToggleablePasswordConfigurer user = new ToggleablePasswordConfigurer("SecretName", Resources.getString("Prefs.password_label"), Resources.getString("Prefs.password_prompt", System.getProperty("user.name")));
        user.addPropertyChangeListener(evt -> GameModule.setUserId((String)evt.getNewValue()));
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), fullName);
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), user);
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), profile);
        GameModule.setUserId(((Configurer)user).getValueString());
    }

    protected void initImagePreferences() {
    }

    protected void initServer() {
        ChatServerFactory.register("node", new NodeClientFactory());
        ChatServerFactory.register("dynamic", new DynamicClientFactory());
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        ChatServerFactory.register("jabber", new JabberClientFactory());
        this.server = new DynamicClient();
        AddressBookServerConfigurer config = new AddressBookServerConfigurer("ServerImpl", "Server", (HybridClient)this.server);
        Prefs.getGlobalPrefs().addOption(Resources.getString("Chat.server"), config);
        this.serverControls = new ChatServerControls();
        this.serverControls.addTo(this);
    }

    protected void initLogger() {
        this.logger = new BasicLogger();
        ((BasicLogger)this.logger).build(null);
        ((BasicLogger)this.logger).addTo(this);
    }

    protected void initGameState() {
        this.theState = new GameState();
        this.theState.addTo(this);
        this.addCommandEncoder(this.theState);
    }

    @Override
    public Command decode(String command) {
        if (command == null) {
            return null;
        }
        Command c = null;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, COMMAND_SEPARATOR);
        String first = st.nextToken();
        if (command.equals(first)) {
            c = this.decodeSubCommand(first);
        } else {
            Command next = null;
            c = this.decode(first);
            while (st.hasMoreTokens()) {
                next = this.decode(st.nextToken());
                c = c == null ? next : c.append(next);
            }
        }
        return c;
    }

    private Command decodeSubCommand(String subCommand) {
        Command c = null;
        for (int i = 0; i < this.commandEncoders.length && c == null; ++i) {
            c = this.commandEncoders[i].decode(subCommand);
        }
        return c;
    }

    @Override
    public String encode(Command c) {
        if (c == null) {
            return null;
        }
        String s = this.encodeSubCommand(c);
        Command[] sub = c.getSubCommands();
        if (sub.length > 0) {
            SequenceEncoder se = new SequenceEncoder(s, COMMAND_SEPARATOR);
            for (Command command : sub) {
                String s2 = this.encode(command);
                if (s2 == null) continue;
                se.append(s2);
            }
            s = se.getValue();
        }
        return s;
    }

    private String encodeSubCommand(Command c) {
        String s = null;
        for (int i = 0; i < this.commandEncoders.length && s == null; ++i) {
            s = this.commandEncoders[i].encode(c);
        }
        return s;
    }

    protected void buildDefaultComponents() {
        this.addComponent(BasicCommandEncoder.class);
        this.addComponent(Documentation.class);
        this.addComponent(PlayerRoster.class);
        this.addComponent(GlobalOptions.class);
        this.addComponent(Map.class);
        this.addComponent(GamePieceImageDefinitions.class);
        this.addComponent(GlobalProperties.class);
        this.addComponent(PrototypesContainer.class);
        this.addComponent(PieceWindow.class);
        this.addComponent(Chatter.class);
        this.addComponent(Language.class);
    }

    protected void initFrame() {
        Rectangle screen = SwingUtils.getScreenBounds(this.frame);
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            this.frame.setLocation(screen.getLocation());
            this.frame.setSize(screen.width, screen.height / 3);
        } else {
            String key = "BoundsOfGameModule";
            Rectangle r = new Rectangle(0, 0, screen.width, screen.height / 4);
            this.getPrefs().addOption(new PositionOption("BoundsOfGameModule", this.frame, r));
        }
        String mess = Resources.getString("BasicModule.version_message", this.getLocalizedGameName(), this.moduleVersion);
        this.warn(mess);
        log.info(mess);
        this.initFrameTitle();
    }

    protected void ensureComponent(Class<? extends Buildable> componentClass) {
        if (this.getComponentsOf(componentClass).isEmpty()) {
            this.addComponent(componentClass);
        }
    }

    protected void addComponent(Class<? extends Buildable> componentClass) {
        Buildable child = null;
        try {
            child = componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleNewInstanceFailure(t, componentClass);
        }
        if (child != null) {
            child.build(null);
            child.addTo(this);
            this.add(child);
        }
    }

    public ChatServerControls getServerControls() {
        return this.serverControls;
    }

    @Override
    public String getI18nPrefix() {
        return "";
    }

    public String toString() {
        return "BasicModule{name='" + this.name + "', moduleVersion='" + this.moduleVersion + "'}";
    }
}

