/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.configure.ConfigureTree;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.List;

public class ComponentPathBuilder {
    private static ComponentPathBuilder instance;

    public static ComponentPathBuilder getInstance() {
        if (instance == null) {
            instance = new ComponentPathBuilder();
        }
        return instance;
    }

    public String getId(Configurable[] targetPath) {
        SequenceEncoder se = new SequenceEncoder('/');
        for (Configurable configurable : targetPath) {
            String name = configurable.getConfigureName();
            SequenceEncoder se2 = new SequenceEncoder(configurable.getClass().getName(), ':');
            if (name != null) {
                se2.append(name);
            }
            se.append(se2.getValue());
        }
        return se.getValue() == null ? "" : se.getValue();
    }

    public Configurable[] getPath(String id) throws PathFormatException {
        ArrayList<Configurable> list = new ArrayList<Configurable>();
        if (id.length() > 0) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(id, '/');
            this.addToPath(GameModule.getGameModule(), st, list);
        }
        return list.toArray(new Configurable[0]);
    }

    private void addToPath(Configurable parent, SequenceEncoder.Decoder st, List<Configurable> path) throws PathFormatException {
        if (st.hasMoreTokens()) {
            String id = st.nextToken();
            String name = null;
            SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(id, ':');
            String className = st2.nextToken();
            if (st2.hasMoreTokens()) {
                name = st2.nextToken();
            }
            Configurable[] children = parent.getConfigureComponents();
            Configurable match = null;
            ArrayList<Configurable> partialMatches = new ArrayList<Configurable>();
            int i = -1;
            while (++i < children.length) {
                if (!className.equals(children[i].getClass().getName())) continue;
                partialMatches.add(children[i]);
                if (!(name == null ? children[i].getConfigureName() == null : name.equals(children[i].getConfigureName()))) continue;
                match = children[i];
                break;
            }
            if (match != null) {
                path.add(match);
                this.addToPath(match, st, path);
            } else if (!partialMatches.isEmpty()) {
                if (!st.hasMoreTokens()) {
                    path.add((Configurable)partialMatches.get(0));
                } else {
                    ArrayList<Configurable> subPath = null;
                    for (Configurable candidate : partialMatches) {
                        ArrayList<Configurable> l = new ArrayList<Configurable>();
                        try {
                            this.addToPath(candidate, st.copy(), l);
                            subPath = l;
                            subPath.add(0, candidate);
                            break;
                        }
                        catch (PathFormatException pathFormatException) {
                        }
                    }
                    if (subPath != null) {
                        path.addAll(subPath);
                    } else {
                        this.findFailed(className, name, parent);
                    }
                }
            } else {
                this.findFailed(className, name, parent);
            }
        }
    }

    private void findFailed(String className, String name, Configurable parent) throws PathFormatException {
        String msgName = name;
        if (msgName == null) {
            msgName = className.substring(className.lastIndexOf(46) + 1);
        }
        throw new PathFormatException("Could not find " + msgName + " in " + ConfigureTree.getConfigureName(parent.getClass()));
    }

    public static class PathFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PathFormatException(String message) {
            super(message);
        }
    }
}

