/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.DialogUtils;
import VASSAL.tools.swing.DetailsDialog;
import VASSAL.tools.swing.Dialogs;
import java.awt.Component;
import java.awt.Frame;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemDialog {
    private static final Logger logger = LoggerFactory.getLogger(ProblemDialog.class);
    private static final List<String> deprecatedMethods = new ArrayList<String>();

    private ProblemDialog() {
    }

    public static Future<?> show(int messageType, String messageKey, Object ... args) {
        return ProblemDialog.show(messageType, (Component)ProblemDialog.getFrame(), null, messageKey, args);
    }

    public static Future<?> show(int messageType, Component parent, String messageKey, Object ... args) {
        return ProblemDialog.show(messageType, parent, null, messageKey, args);
    }

    public static Future<?> show(int messageType, Throwable thrown, String messageKey, Object ... args) {
        return ProblemDialog.show(messageType, (Component)ProblemDialog.getFrame(), thrown, messageKey, args);
    }

    public static Future<?> show(int messageType, Component parent, Throwable thrown, String messageKey, Object ... args) {
        return ProblemDialog.show(messageType, parent, thrown, Resources.getString(messageKey + "_title"), Resources.getString(messageKey + "_heading"), Resources.getString(messageKey + "_message", args));
    }

    public static Future<?> show(int messageType, Component parent, Throwable thrown, String title, String heading, String message) {
        if (thrown != null) {
            logger.error("", thrown);
        }
        return DialogUtils.enqueue(() -> Dialogs.showMessageDialog(parent, title, heading, message, messageType));
    }

    public static Future<?> showDisableable(int messageType, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(messageType, (Component)ProblemDialog.getFrame(), null, key, messageKey, args);
    }

    public static Future<?> showDisableable(int messageType, Component parent, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(messageType, parent, null, key, messageKey, args);
    }

    public static Future<?> showDisableable(int messageType, Throwable thrown, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(messageType, (Component)ProblemDialog.getFrame(), thrown, key, messageKey, args);
    }

    public static Future<?> showDisableable(int messageType, Component parent, Throwable thrown, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(messageType, parent, thrown, key, Resources.getString(messageKey + "_title"), Resources.getString(messageKey + "_heading"), Resources.getString(messageKey + "_message", args));
    }

    public static Future<?> showDisableable(int messageType, Component parent, Throwable thrown, Object key, String title, String heading, String message) {
        if (thrown != null) {
            logger.error("", thrown);
        }
        return DialogUtils.enqueue(() -> Dialogs.showMessageDialog(parent, title, heading, message, messageType, key, Resources.getString("Dialogs.disable")));
    }

    public static Future<?> showDisableableNoI18N(int messageType, Throwable thrown, Object key, String title, String heading, String message) {
        if (thrown != null) {
            logger.error("", thrown);
        }
        return DialogUtils.enqueue(() -> Dialogs.showMessageDialog(ProblemDialog.getFrame(), title, heading, message, messageType, key, Resources.getString("Dialogs.dont_show_again")));
    }

    public static Future<?> showDetails(int messageType, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(messageType, (Component)ProblemDialog.getFrame(), null, details, messageKey, args);
    }

    public static Future<?> showDetails(int messageType, Component parent, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(messageType, parent, null, details, messageKey, args);
    }

    public static Future<?> showDetails(int messageType, Throwable thrown, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(messageType, (Component)ProblemDialog.getFrame(), thrown, details, messageKey, args);
    }

    public static Future<?> showDetails(int messageType, Component parent, Throwable thrown, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(messageType, parent, thrown, details, Resources.getString(messageKey + "_title"), Resources.getString(messageKey + "_heading"), Resources.getString(messageKey + "_message", args));
    }

    public static Future<?> showDetails(int messageType, Component parent, Throwable thrown, String details, String title, String heading, String message) {
        if (thrown != null) {
            logger.error("", thrown);
        }
        return DialogUtils.enqueue(() -> DetailsDialog.showDialog(parent, title, heading, message, details, Resources.getString("Dialogs.disable"), Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), messageType, null));
    }

    public static Future<?> showDetailsDisableable(int messageType, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(messageType, (Component)ProblemDialog.getFrame(), null, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(int messageType, Component parent, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(messageType, parent, null, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(int messageType, Throwable thrown, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(messageType, (Component)ProblemDialog.getFrame(), thrown, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(int messageType, Component parent, Throwable thrown, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(messageType, parent, thrown, details, key, Resources.getString(messageKey + "_title"), Resources.getString(messageKey + "_heading"), Resources.getString(messageKey + "_message", args));
    }

    public static Future<?> showDetailsDisableable(int messageType, Component parent, Throwable thrown, String details, Object key, String title, String heading, String message) {
        if (thrown != null) {
            logger.error("", thrown);
        }
        return DialogUtils.enqueue(() -> DetailsDialog.showDialog(parent, title, heading, message, details, Resources.getString("Dialogs.disable"), Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), messageType, key));
    }

    private static Frame getFrame() {
        return GameModule.getGameModule() == null ? null : GameModule.getGameModule().getPlayerWindow();
    }

    public static Future<?> showDeprecated(String date) {
        List frames = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE), 3).walk(f -> f.skip(1L).limit(2L).collect(Collectors.toList()));
        String method = ((StackWalker.StackFrame)frames.get(0)).getClassName() + "." + ((StackWalker.StackFrame)frames.get(0)).getMethodName();
        if (deprecatedMethods.contains(method)) {
            return null;
        }
        deprecatedMethods.add(method);
        String callingMethod = ((StackWalker.StackFrame)frames.get(1)).getClassName() + "." + ((StackWalker.StackFrame)frames.get(1)).getMethodName();
        LocalDate deprecateFrom = LocalDate.parse(date, DateTimeFormatter.ofPattern("uuuu-M-d"));
        LocalDate warnUntil = deprecateFrom.plusMonths(9L);
        String expiry = deprecateFrom.plusYears(1L).format(DateTimeFormatter.ofPattern("d-MMM-uuuu", Resources.getLocale()));
        String expiryDetails = Resources.getString("Dialogs.deprecated.message", expiry);
        logger.warn(Resources.getString("Dialogs.deprecated.detailed_message", method, callingMethod, expiry));
        if (deprecatedMethods.size() == 1) {
            if (LocalDate.now().isBefore(warnUntil)) {
                GameModule.getGameModule().warn("[" + Resources.getString("Dialogs.out_of_date") + "] " + expiryDetails);
                GameModule.getGameModule().warn("[" + Resources.getString("Dialogs.out_of_date") + "] " + Resources.getString("Dialogs.check_for_updated_module"));
                DialogUtils.setDisabled(expiryDetails, true);
                return null;
            }
            return ProblemDialog.showDisableable(2, null, null, (Object)method, Resources.getString("Dialogs.out_of_date"), Resources.getString("Dialogs.out_of_date"), expiryDetails + "\n\n" + Resources.getString("Dialogs.check_for_updated_module"));
        }
        return null;
    }

    public static Future<?> showOutdatedUsage(String usage) {
        return ProblemDialog.showDisableable(2, null, null, (Object)usage, Resources.getString("Dialogs.out_of_date"), Resources.getString("Dialogs.out_of_date"), Resources.getString("Dialogs.out_dated_usage", usage) + "\n\n" + Resources.getString("Dialogs.check_for_updated_module"));
    }

    public static Future<?> showOutdatedModule(String usage) {
        return ProblemDialog.showDisableable(2, null, null, (Object)usage, Resources.getString("Dialogs.module_version_incompatible"), Resources.getString("Dialogs.module_version_incompatible"), Resources.getString("Dialogs.module_version_incompatible_sequence", usage) + "\n\n" + Resources.getString("Dialogs.check_for_updated_vmod"));
    }
}

