/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.WarningDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ReadErrorDialog {
    private ReadErrorDialog() {
    }

    public static void error(Throwable t, IOException e, String filename) {
        if (e instanceof FileNotFoundException) {
            WarningDialog.showDisableable(t, (Object)(e.getClass().getName() + "@" + filename), "Error.file_not_found", filename);
        } else {
            ErrorDialog.showDisableable(t, (Object)(e.getClass().getName() + "@" + filename), "Error.file_read_error", filename);
        }
    }

    public static void error(Throwable t, IOException e, File file) {
        ReadErrorDialog.error(t, e, file.getPath());
    }

    public static void error(IOException e, String filename) {
        ReadErrorDialog.error((Throwable)e, e, filename);
    }

    public static void error(IOException e, File file) {
        ReadErrorDialog.error((Throwable)e, e, file.getPath());
    }

    public static void errorNoI18N(IOException e, String filename) {
        ErrorDialog.showDisableable(null, (Throwable)e, (Object)(e.getClass().getName() + "@" + filename), "Unable to Read File", "Unable to Read File", "VASSAL was unable to read the file '" + filename + "'.");
    }

    public static void errorNoI18N(IOException e, File file) {
        ReadErrorDialog.errorNoI18N(e, file.getPath());
    }
}

