/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent.listener;

import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.MultiEventListenerSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultMultiEventListenerSupport
implements MultiEventListenerSupport {
    protected final ConcurrentMap<Class<?>, List<EventListener<?>>> listeners = new ConcurrentHashMap();
    protected final Object src;

    public DefaultMultiEventListenerSupport(Object src) {
        this.src = src;
    }

    @Override
    public <T> void addEventListener(Class<T> c, EventListener<? super T> l) {
        this.listeners.putIfAbsent(c, new CopyOnWriteArrayList());
        for (Map.Entry e : this.listeners.entrySet()) {
            Class other = (Class)e.getKey();
            if (!c.isAssignableFrom(other)) continue;
            ((List)e.getValue()).add(l);
        }
    }

    @Override
    public <T> void removeEventListener(Class<T> c, EventListener<? super T> l) {
        for (Map.Entry e : this.listeners.entrySet()) {
            Class other = (Class)e.getKey();
            if (!c.isAssignableFrom(other)) continue;
            ((List)e.getValue()).remove(l);
        }
    }

    @Override
    public boolean hasEventListeners(Class<?> c) {
        for (Map.Entry e : this.listeners.entrySet()) {
            Class other = (Class)e.getKey();
            if (!other.isAssignableFrom(c) || ((List)e.getValue()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> List<EventListener<? super T>> getEventListeners(Class<T> c) {
        ArrayList<EventListener<T>> list = new ArrayList<EventListener<T>>();
        for (Map.Entry e : this.listeners.entrySet()) {
            Class other = (Class)e.getKey();
            if (!other.isAssignableFrom(c)) continue;
            list.addAll((List)e.getValue());
        }
        return list;
    }

    @Override
    public void notify(Object event) {
        Class<?> c = event.getClass();
        List<EventListener<?>> list = (List<EventListener<?>>)this.listeners.get(c);
        if (list == null) {
            list = this.registerType(c);
        }
        for (EventListener eventListener : list) {
            eventListener.receive(this.src, c.cast(event));
        }
    }

    protected List<EventListener<?>> registerType(Class<?> c) {
        this.listeners.putIfAbsent(c, new CopyOnWriteArrayList());
        HashSet lset = new HashSet();
        for (Map.Entry e : this.listeners.entrySet()) {
            Class other = (Class)e.getKey();
            if (!other.isAssignableFrom(c)) continue;
            lset.addAll((Collection)e.getValue());
        }
        List list = (List)this.listeners.get(c);
        list.addAll(lset);
        return list;
    }
}

