/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.ipc;

import VASSAL.tools.concurrent.listener.MultiEventListenerSupport;
import VASSAL.tools.ipc.Fin;
import VASSAL.tools.ipc.IPCMessage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IPCMessageReceiver
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(IPCMessageReceiver.class);
    protected final ObjectInput in;
    protected final MultiEventListenerSupport lsup;

    public IPCMessageReceiver(ObjectInput in, MultiEventListenerSupport lsup) {
        this.in = in;
        this.lsup = lsup;
    }

    @Override
    public void run() {
        try (ObjectInput objectInput = this.in;){
            IPCMessage msg;
            do {
                msg = (IPCMessage)this.in.readObject();
                this.lsup.notify(msg);
            } while (!(msg instanceof Fin));
        }
        catch (InvalidClassException | OptionalDataException | StreamCorruptedException | ClassCastException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            logger.error("Error while reading IPC message", (Throwable)e);
        }
    }
}

