/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitProperties {
    private static final Logger log = LoggerFactory.getLogger(GitProperties.class);
    private static final String DEFAULT_FILENAME = "git.properties";
    private static final String KEY_GIT_VERSION = "git.version";
    private static final String DEFAULT_GIT_VERSION = "3.x development version";
    private final String filename;
    private final Properties gitProperties;

    public GitProperties() {
        this(DEFAULT_FILENAME);
    }

    public GitProperties(String filename) {
        this.filename = filename;
        this.gitProperties = new Properties();
        this.readGitProperties();
    }

    private void readGitProperties() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(this.filename);){
            if (is == null) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                this.gitProperties.load(reader);
            }
        }
        catch (IOException e) {
            log.error("Error while trying to read properties from {}", (Object)this.filename, (Object)e);
        }
    }

    public String getVersion() {
        return this.gitProperties.getProperty(KEY_GIT_VERSION, DEFAULT_GIT_VERSION);
    }
}

